﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerTrProductStructureRepository : IApiConfigRepositoryBase<SigerTrProductStructure>
    {
        IPagedCollectionResult<ProductStructure> GetPagedList(string name, string pn, int pid, int projectid, int page = 1, int pagesize = 10);

        List<ProductStructure> GetDataList(string name, string pn, int pid, int projectid);

        CommonImportResult ImportPorductStructure(IEnumerable<ProductStructureTemplate> productStructure, int projectid);

        List<ProductStructure> GetListByParentId(int pid, int projectid);
    }
}
