using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.Repository.Repositories
{
   internal class Siger_wms_areaRepository: ApiConfigRepositoryBase<siger_wms_area>, Isiger_wms_areaRepository
    {
       private readonly ApiConfigDbContext dbContext;
        public Siger_wms_areaRepository(ApiConfigDbContext context) : base(context)
        {
            dbContext = context;
        }

        public List<int> GetAreaIDs(int pid = 0)
        {
            var ids = new List<int>() { pid };
            var son = new List<int>();
            while (true)
            {
                var id = dbContext.siger_wms_area.Where(f => ids.Contains(f.pid)).Select(f => f.id).ToList();
                if (id.Count() == 0)
                {
                    son.AddRange(ids);
                    break;
                }
                else
                {
                    ids.Clear();
                    ids.AddRange(id.AsEnumerable());
                }
            }
            return son;
        }

        public IEnumerable<LevelSectionTree> GetAreaType(WMSEnum type)
        {
            var list = new List<LevelSectionTree>();
            
            switch (type)
            {
                case WMSEnum.Business:
                    break;
                case WMSEnum.Customer:
                    break;
                default:
                   break;
            }
            //ȡһ
            //var last = GetAreaIDs();
            ////ȡ¼еcity
            //var citys = dbContext.siger_wms_bussinese_contacts.Where(f =>f.supply_type==(int)type&& f.status == (int)RowState.Valid).Select(f => f.cityid).Distinct().ToList();
            ////
            //var except=last.Except(citys);
            ////м¼ĸ
            //var provins=GetList(f => citys.Contains(f.id)).Select(f=>f.pid);
            //var area= GetList(f => provins.Contains(f.id)).Select(f => f.pid);

            //ȥһ¼вûжӦͻ¼,ֻؼ¼cityӦϢ
            var query = GetList(f => f.status == (int)RowState.Valid);
            foreach (var typeData in query)
            {
                list.Add(new LevelSectionTree { id = typeData.id, name = typeData.name, pid = typeData.pid, open = true });
            }

            return list;
        }

        public List<LevelSectionTree> GetLastArea()
        {
            var list = new List<LevelSectionTree>();

            //var ids = GetAreaIDs();
            var query = GetList(f => f.status == (int)RowState.Valid);
            foreach (var type in query)
            {
                list.Add(new LevelSectionTree { id = type.id, name = type.name, pid = type.pid, open = true });
            }
            return list;
        }

        public IEnumerable<int> GetParentAreaIds(int id)
        {
            var list = new List<int> {id};

            var query = GetParentAreas(id);

            foreach (var section in query.ToList())
            {
                list.Add(section.id);
            }

            return list.OrderBy(q => q).Distinct().ToList();
        }

        public IEnumerable<siger_wms_area> GetParentAreas(int id)
        {
            var query = from c in dbContext.siger_wms_area
                        where c.id == id && c.status == (int)RowState.Valid
                select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetParentAreas(t.pid)));
        }
    }
}

