﻿using Siger.Middlelayer.Common.ModuleEnum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Siger.Middlelayer.Repository.Request
{
    public class RequestAddBusiness
    {
        [Required(ErrorMessage = "TypeIDNotNull")]
        public int typeNameID { get; set; }
        [Required(ErrorMessage = "BusinessNameNotNull")]
        public string name { get; set; }
        [Required(ErrorMessage = "CompanyNameNotNull")]
        public string enterprise_name { get; set; }
        [Required(ErrorMessage = "AddressNotNull")]
        public string address { get; set; }
        [Required(ErrorMessage = "ContractNotNull")]
        public string linkman { get; set; }
        [Required(ErrorMessage = "PhoneNotNull")]
        public string phone { get; set; }
        [Required(ErrorMessage = "MobileNotNull")]
        public string mobile { get; set; } = string.Empty;
        public string fax { get; set; } = string.Empty;
        public string email { get; set; } = string.Empty;
        public string homepage { get; set; } = string.Empty;
        public string description { get; set; } = string.Empty;

        /// <summary>
        /// 是否停用
        /// </summary>
        public bool statu { get; set; } = false;

        [Required(ErrorMessage = "BusinessTypeNotNull")]
        public WMSEnum type { get; set; } = WMSEnum.Business;

        public string serial_number { get; set; } = string.Empty;

        public string duns { get; set; } = string.Empty;
    }

    public class RequestDelBusiness
    {
        [Required(ErrorMessage = "IDNotNull")]
        public int id { get; set; }
    }
    public class RequestUpdateBusiness : RequestAddBusiness
    {
        [Required(ErrorMessage = "IDNotNull")]
        public int id { get; set; }
    }
}
