﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.Repository.Request
{
    public class RequestAddRoute
    {
        public int productid { get; set; }

        public IEnumerable<RouteInfo> routes { get; set; }
    }

    public class RequestUpdateRoute
    {
        public int id { get; set; }

        public string description { get; set; }

        public string hours { get; set; }

        public string prepare { get; set; }
    }

    public class RouteInfo
    {
        public string route_ordernumber { get; set; }

        public string machine_type { get; set; }

        [Required(ErrorMessage = "NameIsEmpty")]
        public string route_name { get; set; }

        public string description { get; set; }

        public string hours { get; set; }

        public string prepare { get; set; }
    }
}
