﻿using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Response;

namespace Siger.Middlelayer.TlmRepository.Repositories
{
    internal class ToolLifeToolPackageRepository : TlmRepositoryBase<siger_project_toollife_package>, IToolLifeToolPackageRepository
    {
        private readonly ApiTlmDbContext _context;
        public ToolLifeToolPackageRepository(ApiTlmDbContext context) : base(context)
        {
            _context = context;
        }

        public ResponseGetPackageInfo GetMatterInfoByCode(string handlerCode, int projectId)
        {
            var stock = _context.siger_wms_stock.FirstOrDefault(q => (q.serial_number == handlerCode || q.batch_number == handlerCode) && q.projectid == projectId && q.status == (int)RowState.Valid);
            if (stock == null)
            {
                return null;
            }

            var handler = _context.siger_project_toollife_tool.FirstOrDefault(q =>
                q.part_no == stock.material_pn && q.project_id == projectId && q.status == (int)RowState.Valid);

            if (handler == null)
            {
                return null;
            }

            return new ResponseGetPackageInfo
            {
                tool_id = handler.id,
                matterCode = handlerCode,
                matterType = handler.category == TlmSettingCategory.Handler ? "1" : (handler.category == TlmSettingCategory.Cutter ? "2" : "3"),
                matterName = stock.material_name,
                isBatchNumber = handlerCode == stock.batch_number ? 1 : 0,
                toolcode = handler.number
            };
        }

        public ResponseGetMatterInfo GetMatterInfo(string handlerCode, int projectId)
        {
            var stock = _context.siger_wms_stock.FirstOrDefault(q => (q.serial_number == handlerCode || q.batch_number == handlerCode) && q.projectid == projectId &&
                q.status == (int)RowState.Valid);
            if (stock == null)
            {
                return null;
            }

            var handler = _context.siger_project_toollife_tool.FirstOrDefault(q =>
                q.part_no == stock.material_pn && q.project_id == projectId && q.status == (int)RowState.Valid);

            if (handler == null)
            {
                return null;
            }

            var response = new ResponseGetMatterInfo
            {
                matterCode = handlerCode,
                matterType = handler.category == TlmSettingCategory.Handler
                    ? 1
                    : (handler.category == TlmSettingCategory.Cutter ? 2 : 3),
                matterName = stock.material_name,
                matterOrder = string.IsNullOrWhiteSpace(stock.batch_number) ? stock.serial_number : stock.batch_number,
            };

            //带出已安装的全部信息
            var packageTool = _context.siger_project_toollife_package.FirstOrDefault(q => q.code == handlerCode && q.status == (int)RowState.Valid
                                           && q.confirm_status == ChoiceStatus.HasApply);
            if (packageTool != null)
            {
                response.isAssembled = stock.batch_number == packageTool.code ? "0" : "1";

                var packages = _context.siger_project_toollife_package.Where(q => q.assemble_code == packageTool.assemble_code && q.status == (int)RowState.Valid
                                          && q.confirm_status == ChoiceStatus.HasApply);
                if (packages.Any())
                {
                    var packageHandler = packages.FirstOrDefault(q => q.assemble_code == q.code);
                    if (packageHandler != null)
                    {
                        response.assembHandle = packageHandler.assemble_code;
                        var info = _context.siger_wms_stock.FirstOrDefault(q => (q.serial_number == packageHandler.code || q.batch_number == packageHandler.code) &&
                                                                                q.projectid == projectId && q.status == (int)RowState.Valid);
                        if (info != null)
                        {
                            response.detailInfo.Add(new DetailInfo
                            {
                                materialId = info.material_id,
                                matterCode = packageHandler.code,
                                matterType = 1,
                                matterName = info.material_name,
                                matterOrder = string.IsNullOrWhiteSpace(info.batch_number) ? info.serial_number : info.batch_number,
                                isAssembled = info.batch_number == packageHandler.code ? "0" : "1",
                                assembHandle = packageHandler.code,
                                location = packageHandler.location,
                            });
                        }

                        foreach (var package in packages.Where(q => q.assemble_code != q.code).OrderBy(q => q.location).ToList())
                        {
                            var toolinfo = _context.siger_wms_stock.FirstOrDefault(q => (q.serial_number == package.code || q.batch_number == package.code) &&
                                                                                    q.projectid == projectId && q.status == (int)RowState.Valid);
                            if (toolinfo == null)
                            {
                                continue;
                            }
                            response.detailInfo.Add(new DetailInfo
                            {
                                materialId = toolinfo.material_id,
                                matterCode = package.code,
                                matterType = 2,
                                matterName = toolinfo.material_name,
                                matterOrder = string.IsNullOrWhiteSpace(toolinfo.batch_number) ? toolinfo.serial_number : toolinfo.batch_number,
                                location = package.location,
                                isAssembled = toolinfo.batch_number == package.code ? "0" : "1",
                                assembHandle = packageHandler.code
                            });
                        }
                    }
                }
            }
            else
            {
                response.detailInfo.Add(new DetailInfo
                {
                    materialId = stock.material_id,
                    matterCode = handlerCode,
                    matterType = handler.category == TlmSettingCategory.Handler
                        ? 1
                        : (handler.category == TlmSettingCategory.Cutter ? 2 : 3),
                    matterName = stock.material_name,
                    matterOrder = string.IsNullOrWhiteSpace(stock.batch_number) ? stock.serial_number : stock.batch_number,
                });
            }


            foreach (var item in response.detailInfo)
            {
                var tool = _context.siger_project_toollife_tool.FirstOrDefault(f => f.status != 0 && f.project_id == projectId && f.material_id == item.materialId);
                if (tool == null)
                {
                    continue;
                }
                item.toolNumber = tool.number;
                item.toolId = tool.id;
            }
            return response;
        }

        public bool HasInstall(string handlerCode, int projectId)
        {
            var stock = _context.siger_wms_stock.FirstOrDefault(q => q.serial_number == handlerCode
                                                                     && q.projectid == projectId && q.status == (int)RowState.Valid);
            if (stock != null)
            {
                var install = _context.siger_project_toollife_tool_install.FirstOrDefault(q =>
                    q.tool_code == handlerCode && q.project_id == projectId && q.install_category == InstallCategory.Install
                                               && q.status == (int)RowState.Valid);
                if (install != null)
                {
                    return true;
                }
            }

            return false;
        }

    }

}
