﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Repository.Request;

namespace Siger.Middlelayer.TlmRepository.Request
{
    public class RequestAddToolInfo
    {
        public int category_id { get; set; }

        public string category_name { get; set; }

        [Required(ErrorMessage = "NameIsEmpty")]
        public string name { get; set; }

        public string number { get; set; }
        public string need_detection { get; set; }

        public string partno { get; set; }

        public string image { get; set; }

        public string image_name { get; set; }

        public string video { get; set; }

        public IEnumerable<RequestKeyValue> paraValue { get; set; }

        /// <summary>
        /// 1. 刀具 2. 刀柄 3. 附件 4. 刀头
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// 刀具id ,为空时为添加
        /// </summary>
        public string toolid { get; set; }

        /// <summary>
        /// 是否修磨 1是 2不是
        /// </summary>
        public string grind { get; set; }

        /// <summary>
        /// 修磨次数
        /// </summary>
        public string grind_times { get; set; }

        /// <summary>
        /// 修磨方式 1自主修磨 2外协修磨
        /// </summary>
        public string grind_type { get; set; }

        /// <summary>
        /// 使用次数
        /// </summary>
        public string use_times { get; set; }

        public int material_id { get; set; }
        /// <summary>
        /// 1需要测试2不需要测试
        /// </summary>
        public int need_test { get; set; }
    }

    public class RequestEditToolInfo : RequestAddToolInfo
    {
        public int id { get; set; }
    }

    public class RequestExportToolInfo
    {
        public string name { get; set; }

        public TlmSettingCategory category { get; set; }
    }
}
