﻿using Siger.Middlelayer.Repository.Request;
using System;

namespace Siger.Middlelayer.TlmRepository.Request
{
    public class RequestGetToolInstall : RequestPageBase
    {
        public string machine_code { get; set; }

        public string cutter_number { get; set; }

        public string section_id { get; set; }
    }

    public class RequestToolInstallInfo : RequestPageBase
    {
        /// <summary>
        /// 统计指标1-设备维度2-刀具维度
        /// </summary>
        public string type { get; set; }
        /// <summary>
        /// 刀具编号
        /// </summary>
        public string toolNumber { get; set; }
        /// <summary>
        /// 供应商Id
        /// </summary>
        public int businessId { get; set; }
        /// <summary>
        /// 安装起始时间
        /// </summary>
        public int start { get; set; }
        /// <summary>
        /// 安装结束时间
        /// </summary>
        public int end { get; set; }
        /// <summary>
        /// 安装人
        /// </summary>
        public string installUser { get; set; }
        public string toExcel { get; set; }
        /// <summary>
        /// 设备
        /// </summary>
        public string machineCode { get; set; }
        /// <summary>
        /// 刀位号
        /// </summary>
        public string toolLocaltion { get; set; }
        /// <summary>
        /// 工站
        /// </summary>
        public int section { get; set; }

    }

    public class RequestToolUnusualReason
    {
        public string xtype { get; set; }

        public string reason { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; }
    }

    public class RequestGetToolAmount
    {
        public string stype { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; }
    }

    public class RequestToolUseData : RequestPageBase
    {
        public string Code { get; set; }
        public DateTime Begin { get; set; }
        public DateTime End { get; set; }
        public int Uid { get; set; }
    }
    public class RequestToolProcessData : RequestPageBase
    {
        public string Supplier { get; set; }
        public DateTime Begin { get; set; }
        public DateTime End { get; set; }
        public string MaterialCode { get; set; }
        public string ToolName { get; set; }
    }

    public class RequestGetToolUseCount : RequestPageBase
    {
        public string name { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; }

        public string toexcel { get; set; }
    }


    public class RequestToolLifeAnalysis 
    {
        /// <summary>
        /// 安装起始时间
        /// </summary>
        public int start { get; set; }
        /// <summary>
        /// 安装结束时间
        /// </summary>
        public int end { get; set; }
        /// <summary>
        /// 设备
        /// </summary>
        public int machine { get; set; }
        /// <summary>
        /// 工序
        /// </summary>
        public int route { get; set; }
        /// <summary>
        /// 产品
        /// </summary>
        public int product { get; set; }
    }
}
