﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Repository.Request;

namespace Siger.Middlelayer.TlmRepository.Request
{
    public class RequestGetToolReplaceReturn : RequestPageBase
    {
        public string workorder_id { get; set; }

        public string material_id { get; set; }

        public string operate_mid { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; }
    }

    public class RequestToolReplace
    {
        public string status { get; set; }

        public string workorder_id { get; set; }

        public string material_id { get; set; }

        public string quantity { get; set; }

        public string operate_mid { get; set; }

        public string serial_number { get; set; }

        public string supplier_id { get; set; }

        public string storage_id { get; set; }
    }
    public class RequestReplaceReturn
    {
        public StorageCategory storagecategory { get; set; }
        public int id { get; set; }
        public int waveHouseID { get; set; }
        public int locationId { get; set; } = 0;
    }
    public class RequestReplaceReturnAfterGrind
    {
        /// <summary>
        /// 物料Id
        /// </summary>
        public int materialId { get; set; }
        /// <summary>
        /// 仓库Id
        /// </summary>
        public int waveHouseID { get; set; }
        /// <summary>
        /// 数量
        /// </summary>
        public int count { get; set; }
        public int id { get; set; }
        public int storage_location_id { get; set; } = 0;
    }
    public class RequestToolReturn
    {
        public string workorder_id { get; set; }

        public string operate_mid { get; set; }
        public int waveHouseID { get; set; }

        public List<SendBackModel> sendbacks { get; set; }
    }

    public class SendBackModel
    {
        public string status { get; set; }

        public string material_id { get; set; }

        public string quantity { get; set; }

        public string serial_number { get; set; }

        public string supplier_id { get; set; }
    }

    public class RequestRecieve
    {
        public string sn { get; set; }

        public string picker { get; set; }

        public string quantity { get; set; }
    }
}
