﻿namespace Siger.Middlelayer.TlmRepository.Response
{
    public class ResponseGetTechToolList
    {
        public int id { get; set; }

        public int machine_type { get; set; }

        public int product_id { get; set; }

        /// <summary>
        /// 零件图纸号
        /// </summary>
        public string drawcode { get; set; }

        public string cutter_number { get; set; }

        /// <summary>
        /// 刀具规格
        /// </summary>
        public int tool_model { get; set; }

        /// <summary>
        /// 刀柄规格
        /// </summary>
        public int handle_model { get; set; }

        /// <summary>
        /// 刀具规格名称
        /// </summary>
        public string tool_modelName { get; set; }

        /// <summary>
        /// 刀柄规格名称
        /// </summary>
        public string handle_modelName { get; set; }

        /// <summary>
        /// 刃长
        /// </summary>
        public double flute_length { get; set; }

        /// <summary>
        /// 刃数
        /// </summary>
        public int flute_count { get; set; } = 0;

        /// <summary>
        /// 首下长
        /// </summary>
        public string down_length { get; set; }

        /// <summary>
        /// 伸出长
        /// </summary>
        public string reach_length { get; set; }

        /// <summary>
        /// 上公差
        /// </summary>
        public string upper_tolerance { get; set; }

        /// <summary>
        /// 下公差
        /// </summary>
        public string down_tolerance { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        public int choice_status { get; set; }

        /// <summary>
        /// 物料料号
        /// </summary>
        public string part_no { get; set; }

        /// <summary>
        /// 物料名称
        /// </summary>
        public string material_name { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int quantity { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string category_name { get; set; }

        /// <summary>
        /// 设备数量
        /// </summary>
        public int machine_quantity { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        public string rated_life { get; set; }

        public int material_id { get; set; }

        public int route_id { get; set; }
        public string tool_code { get; set; }
        /// <summary>
        /// 刀具号
        /// </summary>
        public string tool_number { get; set; }
    }

    public class ResponseGetToolChoiceSummary
    {
        public int id { get; set; }

        public int tech_tool_id { get; set; }

        /// <summary>
        /// 物料料号
        /// </summary>
        public string part_no { get; set; }

        /// <summary>
        /// 物料名称
        /// </summary>
        public string material_name { get; set; }
        public int material_id { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }

        /// <summary>
        /// 位置
        /// </summary>
        public string position { get; set; }

        public int positionId { get; set; }
        public int category_id { get; set; }
        public int quantity { get; set; }

        public int stock { get; set; }
        public string cutter_number { get; set; } = "";

        public string number { get; set; }
    }
}
