﻿using System;
using System.Reflection;
using Microsoft.Extensions.DependencyInjection;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Repositories;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;

namespace Siger.Middlelayer.TlmRepository
{
    public class TlmRepositoryFactory
    {
        private static TlmRepositoryFactory _factory;

        public static TlmRepositoryFactory Instance => _factory ?? (_factory = new TlmRepositoryFactory());

        public void Initialization(IServiceCollection services)
        {
            RepositoryFactory.Instance.DiRepositories(services, typeof(IApiConfigRepositoryBase<>));
            WmsRepositoryFactory.Instance.DiRepositories(services, typeof(IWMSRepositoryBase<>));
            DiRepositories(services, typeof(ITlmRepositoryBase<>));
            services.AddDbContext<ApiConfigDbContext>();
            services.AddDbContext<ApiTlmDbContext>();
            services.AddDbContext<ApiWmsDbContext>();
            services.AddScoped(typeof(IUnitOfWork), typeof(TlmUnitOfWork));
        }

        public void DiRepositories(IServiceCollection services, Type moduleType)
        {
            foreach (Type type in Assembly.Load(GetType().Assembly.GetName()).GetTypes())
            {
                if (typeof(IRepository).IsAssignableFrom(type) && type.IsClass && !type.IsAbstract)
                {
                    var interfaces = type.GetInterfaces();
                    foreach (var i in interfaces)
                    {
                        if (!i.IsGenericType && i != typeof(IRepositoryBase<>)
                                             && i != typeof(IRepository)
                                             && i.Name != moduleType.Name)
                        {
                            services.AddScoped(i, type);
                        }
                    }
                }
            }
        }
    }
}
