﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.ToolRepository.Entities;

namespace Siger.Middlelayer.ToolRepository
{
    public class ApiToolDbContext : DbContext
    {
        public ApiToolDbContext()
        {

        }

        public ApiToolDbContext(DbContextOptions<ApiToolDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

            modelBuilder.Entity<SigerProjectToolCutterLocationAlarm>().ToTable("siger_project_tool_cutter_location_alarm");
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<SigerProjectTool> siger_project_tool { get; set; }
        public DbSet<SigerProjectToolAlarm> siger_project_tool_alarm { get; set; }
        public DbSet<SigerProjectToolAlarmTotal> SigerProjectToolAlarmTotal { get; set; }
        public DbSet<SigerProjectToolAlertCondition> siger_project_tool_alert_condition { get; set; }
        public DbSet<SigerProjectToolBlx> siger_project_tool_blx { get; set; }
        public DbSet<SigerProjectToolBlxCutter> siger_project_tool_blx_cutter { get; set; }
        public DbSet<SigerProjectToolBlxCutterLog> siger_project_tool_blx_cutter_log { get; set; }
        public DbSet<SigerProjectToolBlxLog> siger_project_tool_blx_log { get; set; }
        public DbSet<SigerProjectToolCutterLocation> siger_project_tool_cutter_location { get; set; }
        public DbSet<SigerProjectToolCutterLocationAlarm> siger_project_tool_cutter_location_alarm { get; set; }
        public DbSet<SigerProjectToolCutterLocationTrue> siger_project_tool_cutter_location_true { get; set; }
        public DbSet<SigerProjectToolEmailConfig> siger_project_tool_email_config { get; set; }
        public DbSet<SigerProjectToolSpindle> siger_project_tool_spindle { get; set; }
        public DbSet<SigerProjectToolSpindleTrue> siger_project_tool_spindle_true { get; set; }
        public DbSet<SigerProjectToolStudy> siger_project_tool_study { get; set; }


        public DbSet<SigerToolBlx> siger_tool_blx { get; set; }
        public DbSet<SigerToolBlxLog> siger_tool_blx_log { get; set; }
        public DbSet<siger_tool_change_record> siger_tool_change_record { get; set; }
        public DbSet<SigerToolHistroySaveSetting> siger_tool_histroy_save_setting { get; set; }
        public DbSet<SigerToolListTotal> SigerToolListTotal { get; set; }
        public DbSet<SigerToolLoacationProjectToolTotal> SigerToolLoacationProjectToolTotal { get; set; }
        public DbSet<SigerToolSendMessageType> siger_tool_send_message_type { get; set; }
        public DbSet<SigerToolTotalRealUrl> SigerToolTotalRealUrl { get; set; }
        public DbSet<SigerToolUiRefreshFrequency> SigerToolUiRefreshFrequency { get; set; }

        public DbSet<siger_project_level> siger_project_level { get; set; }
        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }
        public DbSet<siger_project_level_section_machine> siger_project_level_section_machine { get; set; }
        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<siger_project_product> siger_project_product { get; set; }
        public DbSet<Storm_programlist> storm_programlist { get; set; }
        public DbSet<siger_alert_condition> siger_alert_condition { get; set; }
        public DbSet<SigerProjectToolChangeExtend> siger_tool_change_record_extend { get; set; }
        public DbSet<SigerProjectToolMS> siger_project_tool_ms { get; set; }

        public DbSet<siger_project_tool_blx_bd> siger_project_tool_blx_bd { get; set; }
        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
    }
}
