
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_project_tool Entity Model
    /// </summary>   
    public class SigerProjectTool: ToolEntityBase
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int id { get; set; }
   
        /// <summary>
        /// 项目 id 与 _project id 对应
        /// </summary>
        public int projectid { get; set; }
   
        /// <summary>
        /// 刀具名称
        /// </summary>
        public string name { get; set; }
   
        /// <summary>
        /// 规格
        /// </summary>
        public string spec { get; set; }
   
        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; }
   
        /// <summary>
        /// 材料
        /// </summary>
        public string material { get; set; }
   
        /// <summary>
        /// 硬度
        /// </summary>
        public string hardness { get; set; }
   
        /// <summary>
        /// 产品图纸号
        /// </summary>
        public string drawingcode { get; set; }
   
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }
   
        /// <summary>
        /// 供应商编号
        /// </summary>
        public string suppliercode { get; set; }
   
        /// <summary>
        /// 刀具供应商图片url
        /// </summary>
        public string supplierimg { get; set; }
   
        /// <summary>
        /// 单价
        /// </summary>
        public float? unitprice { get; set; }
   
        /// <summary>
        /// 备注
        /// </summary>
        public string description { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int status { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int createtime { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int creatorid { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int? updatetime { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int? changerid { get; set; }
    }
}
