
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_project_tool_blx_cutter Entity Model
    /// </summary>   
    public class SigerProjectToolBlxCutter : ToolEntityBase
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]

        public int id { get; set; }
   
        /// <summary>
        /// 公司ID
        /// </summary>
        public int company_id { get; set; }
   
        /// <summary>
        /// 项目ID
        /// </summary>
        public int project_id { get; set; }
   
        /// <summary>
        /// 设备ID
        /// </summary>
        public int machine_id { get; set; }
   
        /// <summary>
        /// 主轴ID（名称，非外键）
        /// </summary>
        public string spindle_name { get; set; }
   
        /// <summary>
        /// 刀位ID（名称，非外键）
        /// </summary>
        public string cutter_location_name { get; set; }
   
        /// <summary>
        /// 程序号
        /// </summary>
        public string program_no { get; set; }
   
        /// <summary>
        /// 开始时间
        /// </summary>
        public int start_time { get; set; }
   
        /// <summary>
        /// 结束时间
        /// </summary>
        public int end_time { get; set; }
        /// <summary>
        /// 刀具标定类型
        /// </summary>
        public int type { get; set; }
        /// <summary>
        /// 样本数量
        /// </summary>
        public int count { get; set; }
        public int userid { get; set; }
        /// <summary>
        /// 状态  1有效  0无效
        /// </summary>
        public int status { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public int update_time { get; set; }
        /// <summary>
        /// 质量描述
        /// </summary>
        public int qualitydesc { get; set; }
        /// <summary>
        /// 标定备注
        /// </summary>
        public string remark { get; set; }
    }
}
