
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_project_tool_cutter_location Entity Model
    /// </summary>   
    public class SigerProjectToolCutterLocation : ToolEntityBase
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int id { get; set; }
   
        /// <summary>
        /// 刀位名称
        /// </summary>
        public string name { get; set; }
   
        /// <summary>
        /// 主轴id
        /// </summary>
        public int spindleid { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int status { get; set; }
   
        /// <summary>
        /// 是否极值轮廓线学习
        /// </summary>
        public int isstudy { get; set; }
   
        /// <summary>
        /// 刀具id
        /// </summary>
        public int toolid { get; set; }
   
        /// <summary>
        /// 转速S（转/分）
        /// </summary>
        public int speed { get; set; }
   
        /// <summary>
        /// 进给量（毫米/转）
        /// </summary>
        public float feedrate { get; set; }
   
        /// <summary>
        /// 吃刀量/钻深（毫米）
        /// </summary>
        public string cuttingdepth { get; set; }
   
        /// <summary>
        /// 加工尺寸
        /// </summary>
        public string machiningtolerance { get; set; }
   
        /// <summary>
        /// 直径补偿
        /// </summary>
        public float dcompensate { get; set; }
   
        /// <summary>
        /// 半径补偿
        /// </summary>
        public float rcompensate { get; set; }
   
        /// <summary>
        /// x轴
        /// </summary>
        public float x { get; set; }
   
        /// <summary>
        /// y轴
        /// </summary>
        public float y { get; set; }
   
        /// <summary>
        /// z轴
        /// </summary>
        public float z { get; set; }
   
        /// <summary>
        /// 冷却方式
        /// </summary>
        public string cooling { get; set; }
   
        /// <summary>
        /// 备注
        /// </summary>
        public string description { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int ratedlife { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public string image_url { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public string programno { get; set; }
   
        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; }
   
        /// <summary>
        /// 更新时间
        /// </summary>
        public int update_time { get; set; }
    }
}
