using System.Collections.Generic;
using System.Threading.Tasks;
using Siger.Middlelayer.Redis.RedisEntities;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Request;
using Siger.Middlelayer.ToolRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.ToolRepository.Repositories.Interface
{
    public interface ISigerProjectToolCutterLocationTrueRepository: IApiToolRepositoryBase<SigerProjectToolCutterLocationTrue>
    {
        IEnumerable<CutterLocationAlarmSetting> GetCutterLocationAlarmSetting(int sectionId, int projectId,int page, int pageSize, out int toalCount);

        bool UpdateAutoStudy(List<int>spindleID,string programNo,int autoStudy);

        List<string> GetToolTypes(int projectID, int sectionId);
        List<ResponseToolLifeList> GetToolLifeList(int projectID, int sectionID);
        ToolInfo GetChangeRecordOtherInfo(int projectId, int companyId, int machine_id, int spindle_id, string cutter_location_name);
        bool SetCutterLocationAlarmSetting(int projectId);
        List<SigerProjectTool> GetToolList(int sectionid, int projectId, string tooltype, string toolfilter, string brand, int count);

        List<MachineData> GetMachineList(string machinefilter, int projectId, int count);

        List<ProductData> GetProductList(string productfilter, int projectId, int count);

        int AddConfigCutterLocation(RequestToolCutterLocationAdd request);

        List<ResponseToolConfigInfo> ExportToolConfigInfo(string programNo, int sectionId, int projectId);

        ToolImportResult ImportToolLocations(IEnumerable<ToolLocationList> tools, int projectId);

        ProductData GetProduct(int id, int projectId);

        ResponseToolLifeEntity GetToolLifeEntity(int id);
        List<ResponseToolAlertSpindle> GetCutterLocationList(int sectionID,int companyId, int projectId,int page,int pagesize, out int totalCount);
        Task<IEnumerable<CutterInfo>> GetCutterByProgramAsync(List<CNCEquipmentState> states);

        IEnumerable<ResponseCutterConfig> GetCutterConfigsByMachine(int machineid);

        List<MachineData> GetMachineBySection(List<int> section, int projectId);
        List<SigerProjectTool> GetToolList(RequestToolList request, int projectid);
    }
}