using System.Collections.Generic;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Response;

namespace Siger.Middlelayer.ToolRepository.Repositories.Interface
{
    public interface ISigerProjectToolcutterLocationalarmRepository: IApiToolRepositoryBase<SigerProjectToolCutterLocationAlarm>
    {
        List<ResponseGetToolAlarmLogInfo> GetAlarmList(int sectionId, int projectId, out int totalCount, string timeSpan, int page, int pageSize);
        AlarmStatistFinalResult GetToolAlarmStatisticsInfo(int sectionId, int projectId, string timeSpan,List<ToolAlarmStatisticsInfo>data);

        /// <summary>
        /// ȡ/δó
        /// </summary>
        /// <returns></returns>
        List<ProgramNo> GetProgralList(ProgramConfig config, int sectionId, int projectId, string name, int count);

        List<ResponseToolConfigInfo> GetToolConfigInfo(string programNo, int sectionID, int projectID, int page, int pagesize, out int totalCount);
        List<ResponseOriginalToolConfigInfo> GetOriginalToolConfigInfo(string programNo,string spn, int sectionID, int projectID, int page, int pagesize, out int totalCount);

        IEnumerable<ResponseGetToolAlarmLogInfo> ExportAlarmList(int sectionId, int projectId, string timeSpan);

        ResponseGetCutterLocationEditInfo GetCutterLocationEditInfo(int id);
        //List<SectionMachine> GetMachineId(int sectionId, int projectId);
        IEnumerable<ResponseUnConfigProgramList> GetUnConfigProgramList(string program_no, int sectionid, int projectId, int page, int pageSize, out int totalCount);
        IEnumerable<int> GetMachineIds(int sectionId, int projectId);
        IEnumerable<ResponseConfigProgramlist> GetConfigProgramList(string program_no, int sectionid, int projectId, int page, int pageSize, out int totalCount);

        IEnumerable<SpindleSorting> GetToolinfosByPn(int machine, string program, int is_process);

        IEnumerable<ResponseToolCCModeConfigInfo> GetToolCCModeConfigInfos(string programNo, int sectionID, int projectID, int page, int pagesize, out int totalCount);
    }
}