﻿using System.Collections.Generic;
using System.Linq;
using Newtonsoft.Json.Linq;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Repositories.Interface;

namespace Siger.Middlelayer.ToolRepository.Repositories
{
    internal class KMAlarmRecordDataRepository : ApiToolRepositoryBase<KMAlarmRecordDataEntity>, IKMAlarmRecordDataRepository
    {
        public KMAlarmRecordDataRepository(ApiToolDbContext context) : base(context)
        {
           
        }

        public List<List<object>> FillEchartsData(string stepNumber, string value)
        {
            var result = new List<List<object>>();
            if (stepNumber != null && value != null)
            {
                var steps = JArray.Parse(stepNumber).ToList();
                var values = JArray.Parse(value).ToList();
                if (steps.Count == values.Count)
                {
                    for (int i = 0; i < steps.Count; i++)
                    {
                        int.TryParse(steps[i].ToString(), out int stepNum);
                        string finalValue = "-";
                        if (double.TryParse(values[i].ToString(), out double v))
                        {
                            finalValue = v.ToString();
                        }
                        result.Add(new List<object>()
                        {
                            stepNum,finalValue
                        });
                    }
                    return result;
                }
            }
            throw new System.Exception("temp");
        }
    }
}
