﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Request
{
    public class RequestToolChangeAdd
    {
        [Required(ErrorMessage = "ChangeReasonNotNull")]
        public string change_reason { get; set; }

        public string change_time { get; set; }

        public string comment { get; set; }

        public string cover { get; set; }

        [Required(ErrorMessage = "CutterLocationNameNotNull")]
        public string cutter_location_name { get; set; }

        public string cyc_time { get; set; }

        //[Required(ErrorMessage = "DrawingCodeNotNull")]
        public string drawingcode { get; set; }

        [Required(ErrorMessage = "MachineCodeNotNull")]
        public string machine_code { get; set; }

        [Required(ErrorMessage = "MachineIDNotNull")]
        public string machine_id { get; set; }

        public string program_type { get; set; }

        [Required(ErrorMessage = "MachineNameNotNull")]
        public string machine_name { get; set; }

        [Required(ErrorMessage = "ProgramNoNotNull")]
        public string programno { get; set; }

        [Required(ErrorMessage = "RatedLifeNotNull")]
        public string ratedlife { get; set; }

        [Required(ErrorMessage = "ResidualLifeNotNull")]
        public string residual_life { get; set; }

        [Required(ErrorMessage = "SpindleNameNotNull")]
        public string spindle_name { get; set; }
        
        public string supplier { get; set; }
        
        [Required(ErrorMessage = "SurplusLifeNotNull")]
        public string surplus_life { get; set; }

       // [Required(ErrorMessage = "ToolNameNotNull")]
        public string tool_name { get; set; }
    }

    public class RequestTool
    {
        public int section { get; set; }
        public int page { get; set; }
        public int pagesize { get; set; }
    }
}
