﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Request;
using Siger.Middlelayer.TpmRepository.Response;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface IRepairRepository : ITpmRepositoryBase<siger_project_repair>
    {
        IEnumerable<ResponseUnFinishedRepair> GetUnFinishedRepair(int projectId);

        IPagedCollectionResult<ResponseUnstandardRepairInfo> GetPagedUnstandardRepairInfo(IEnumerable<int> machineIds,
            int startTime, int endTime, int projectId,
            int page, int pagesize);

        IPagedCollectionResult<ResponseGetRepairList> GetPagedRepairList(IEnumerable<int> machineIds, int startTime,
            int endTime, string userName, string repairid, int faulttype_id, int fault_id, int status,
            int compare, double compare_time,int cost,
            int projectId, int andonType, int page, int pagesize, int repairMid, int workordertype, bool paged = true);

        string GetUserNames(IEnumerable<string> userIds);

        IEnumerable<RepairListForMTTR> GetRepairsForMTTR(IEnumerable<int> machineIds, int startTime, int endTime,
            int faulttype_id, int fault_id, int offline, int projectId);

        IEnumerable<RepairListForMTTR> GetAppRepairsForMTTR(IEnumerable<int> machineIds, int startTime, int endTime,
            int projectId);

        IEnumerable<GetStatusRepairList> GetRepairListByMachineArr(IEnumerable<int> machineIds, int status,
            int projectId, int userId);

        IEnumerable<FaultTypeModel> GetFaultTypeList(int typeid, int projectId);

        GetStatusRepairList GetRepairInfoByID(int repairid, int projectId);

        LevelByRepair LevelByRepair(int repairId, int projectId);

        IEnumerable<siger_project_repair_cooperate_reason> GetCooperateReasonList(int projectid, int languageType);

        IEnumerable<ResponseAllRepairs> GetAllRepairs(int projectId, int monthstart, int monthend);

        IEnumerable<ResponseUnFinishedRepair> GetRepairs(int projectId);

        IEnumerable<ResponseAllRepairs> GetAllFinishedRepairs(int projectId, int monthstart, int monthend);

        IEnumerable<RepairListForMTTR> GetRepairsForMTTR(RequestRepairDataTrendMTTREx condition, int projectId);

        IEnumerable<siger_project_level_section> GetAllSections(int projectid);

        IEnumerable<siger_project_level_section> GetAllSonLevelSections(int parentId,IEnumerable<siger_project_level_section> list);
        List<ResponseRepairWorkCount> GetRepairWorkCount(long start, long end, int pid);
    }
}
