﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.Middlelayer.Utility.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;

namespace Siger.Middlelayer.TpmRepository.Repositories
{
    internal class PlanRecordRepository : TpmRepositoryBase<siger_project_plan_record>, IPlanRecordRepository
    {
        private readonly ApiTpmDbContext _context;
        public PlanRecordRepository(ApiTpmDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<GetPlanResult> GetRecordList(IEnumerable<int> machineIds, int startTime, int endTime, int mode, int projectId)
        {
            var queryList = from t in _context.siger_project_plan_record
                            join pitem in _context.siger_project_plan_item on t.itemid equals pitem.id
                            where t.projectid == projectId && t.status == (int)RowState.Valid
                                && machineIds.Contains(pitem.machineid) && t.create_time <= endTime &&
                                t.create_time >= startTime
                            orderby t.create_time
                            select new GetPlanResult
                            {
                                planid = t.planid,
                                plan_time_id = t.plan_time_id,
                                itemid = t.itemid,
                                create_time = t.create_time,
                                create_mid = t.create_mid,
                                actual_mid = t.actual_mid,
                                id = t.id,
                                imgurl = t.imgurl,
                                sparepartout = t.sparepartout,
                                time = UnixTimeHelper.ConvertIntDate(t.create_time),
                                machineid = pitem.machineid,
                                mode = pitem.mode,
                                standard_time = pitem.standard_time
                            };

            Expression<Func<GetPlanResult, bool>> modeExpression = q => true;
            if (mode > 0)
            {
                modeExpression = q => q.mode == mode;
            }

            return queryList.Where(modeExpression).ToList();
        }

        public List<GetPlanResult> GetRecordListEx(IEnumerable<int> machineIds, int startTime, int endTime, int mode, int projectId)
        {
            var ret = new List<GetPlanResult>();
            var records = _context.siger_project_plan_record.Where(f => f.create_time >= startTime && f.create_time <= endTime && f.status != 0 && f.projectid == projectId).ToList();
            if (records.Any())
            {
                var itemids = records.Select(s => s.itemid).ToList();
                var items = _context.siger_project_plan_item.Where(f => itemids.Contains(f.id) && f.status != 0 && f.projectid == projectId && machineIds.Contains(f.machineid)).ToList();
                foreach (var item in records)
                {
                    var actual = 0;
                    var itemdata = _context.siger_project_plan_item.FirstOrDefault(f => f.id == item.itemid && f.status != 0 && f.projectid == projectId && machineIds.Contains(f.machineid));
                    if (itemdata==null)
                    {
                        continue;
                    }
                    var sign = _context.siger_project_plan_sign.Where(f => f.status != 0 && f.projectid == projectId && f.machine_id == itemdata.machineid && f.create_mid == item.create_mid && f.create_time < item.create_time).OrderByDescending(o => o.create_time).FirstOrDefault();
                    if (sign != null)
                    {
                        actual = (item.create_time - sign.create_time)/60;
                    }
                    ret.Add(new GetPlanResult
                    {
                        planid = item.planid,
                        plan_time_id = item.plan_time_id,
                        itemid = item.itemid,
                        create_time = item.create_time,
                        create_mid = item.create_mid,
                        actual_mid = item.actual_mid,
                        id = item.id,
                        imgurl = item.imgurl,
                        sparepartout = item.sparepartout,
                        time = UnixTimeHelper.ConvertIntDate(item.create_time),
                        machineid = itemdata.machineid,
                        mode = itemdata.mode,
                        standard_time = itemdata.standard_time,
                        actual_standard_time = actual
                    });
                }
            }
            if (mode > 0)
            {
                ret = ret.Where(q => q.mode == mode).ToList();
            }
            return ret;
        }
    }
}
