﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.WmsRepository.Entities;

namespace Siger.Middlelayer.WmsRepository
{
    public class ApiWmsDbContext : DbContext
    {
        public ApiWmsDbContext()
        {

        }
        public ApiWmsDbContext(DbContextOptions<ApiWmsDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {

        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_wms_audit_history> siger_wms_audit_history { get; set; }
        public DbSet<siger_wms_bussinese_contacts> siger_wms_bussinese_contacts { get; set; }
        public DbSet<siger_wms_operate_history> siger_wms_operate_history { get; set; }
        public DbSet<siger_wms_power> siger_wms_power { get; set; }
        public DbSet<siger_wms_receive_use> siger_wms_receive_use { get; set; }
        public DbSet<siger_wms_role_power> siger_wms_role_power { get; set; }
        public DbSet<siger_wms_stock> siger_wms_stock { get; set; }
        public DbSet<siger_wms_stocktake_order> siger_wms_stocktake_order { get; set; }
        public DbSet<siger_wms_stocktake_order_detail> siger_wms_stocktake_order_detail { get; set; }
        public DbSet<siger_wms_stock_access_order> siger_wms_stock_access_order { get; set; }
        public DbSet<siger_wms_stock_access_order_detail> siger_wms_stock_access_order_detail { get; set; }
        public DbSet<siger_wms_stock_quantity_change_history> siger_wms_stock_quantity_change_history { get; set; }
        public DbSet<siger_wms_storage> siger_wms_storage { get; set; }
        public DbSet<siger_wms_storage_location> siger_wms_storage_location { get; set; }
        public DbSet<siger_wms_storage_location_type> siger_wms_storage_location_type { get; set; }
        public DbSet<siger_wms_storage_type> siger_wms_storage_type { get; set; }
        public DbSet<siger_wms_transfer_order> siger_wms_transfer_order { get; set; }
        public DbSet<siger_wms_transfer_order_detail> siger_wms_transfer_order_detail { get; set; }
        public DbSet<siger_wms_area> siger_wms_area { get; set; }
        public DbSet<siger_wms_stock_alarm> siger_wms_stock_alarm { get; set; }


        public DbSet<siger_user> siger_user { get; set; }

        public DbSet<siger_wms_settings> siger_wms_settings { get; set; }

        public DbSet<siger_project_section> siger_project_section { get; set; }
        
        public DbSet<siger_tr_materials> siger_tr_materials { get; set; }

        public DbSet<siger_wms_stock_detail> siger_wms_stock_detail { get; set; }

        public DbSet<siger_project_user> siger_project_user { get; set; }
        public DbSet<SigerTrDict> siger_tr_dict { get; set; }

        public DbSet<siger_wms_id> siger_wms_id { get; set; }
        public DbSet<siger_tr_material_type> siger_tr_material_type { get; set; }

        public DbSet<siger_wms_stock_change> siger_wms_stock_change { get; set; }
        public DbSet<SigerTrMaterialSupplier> siger_tr_material_supplier { get; set; }
        public DbSet<siger_project_toollife_toolEx> siger_project_toollife_tool { get; set; }
        public DbSet<ProjectToollifeDetectionRecordEntityEx> siger_project_toollife_detection_record { get; set; }
        public DbSet<ProjectToollifeDetectionEntityEx> siger_project_toollife_detection { get; set; }
        public DbSet<siger_project_ims_toolEx> siger_project_ims_tool { get; set; }
        public DbSet<ProjectIMSDetectionRecordEntityEx> siger_project_ims_detection_record { get; set; }
        public DbSet<ProjectIMSDetectionEntityEx> siger_project_ims_detection { get; set; }
    }
}
