using System;
using System.Collections.Generic;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Data.Wms;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Request;
using Siger.Middlelayer.WmsRepository.Response;

namespace Siger.Middlelayer.WmsRepository.Repositories.Interface
{
    public interface Isiger_wms_stockRepository : IWMSRepositoryBase<siger_wms_stock>
    {
        IEnumerable<ResponseeInventory> GetList(int storageid,string invantorysn, int pid, managemodel type, string filter, int businessID);
        IEnumerable<siger_tr_materials> GetInventoryList(int businessID,int projectId);
        IEnumerable<ResponseeInventory> GetList(int businessid,int storageid, string invantorysn, int locationid, int page, int pageSize, int projectId, out int totalCount,bool paging=true, string batch = "", string no = "");
        IEnumerable<ResponseInventoryInfo> GetAllocationInventoryList(int projectId, string billCode);
        List<ResponseCheckIn> CheckIn(int projectId, int userId, RequestWaveHousing req, Isiger_wms_storage_locationRepository location, bool isReceiving);
        IEnumerable<ResponseIdName> GetBusinessList(int materialID, int projectId);
        IEnumerable<StockTotal> GetStockTotal(int derect, int projectId, int tId, int wid, DateTime start, DateTime end, int page, int pageSize, out int totalCount);
        IEnumerable<StockDetail> GetStockDetails(int derect, int projectId, int tId, int wid, DateTime start, DateTime end, int page, int pageSize, out int totalCount);
        IEnumerable<ResponseStockSummary> StockSummary(int id, int projectId,int page,int pageSize, out int totalCount,bool paging=true);
        ResponseStockChangeHistory GetStockChangeHistory(int storageid,string sn, DateTime start, DateTime end, int projectId, traceType type);
        List<ResponseCheckIn> CheckIn(RequestWaveHousing req);
        IEnumerable<ResponseeInventory> GetListForApp(string code, int projectId);
        bool SyncToolData(RequestPurchaseTools request, int pid);
    }
}
