﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.WmsRepository.Request
{
    /// <summary>
    /// 长龄刀具入库
    /// </summary>
    public class RequestPurchaseTools
    {
        /// <summary>
        /// 采购单号
        /// </summary>
        public string purchase_order { get; set; }
        /// <summary>
        /// 1原材入库      
        /// 2生产入库
        /// 3其他入库     
        /// 4生产领料
        /// 5销售出货       
        /// 6其他出库
        /// 7整刀入库       
        /// 8采购入库      
        /// 9回收入库
        /// 10领用出库
        /// </summary>
        public string inbound_type { get; set; }
        /// <summary>
        /// 入库仓库
        /// </summary>
        public string location { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public string create_time { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public string create_user { get; set; }
        /// <summary>
        /// 审核状态
        /// </summary>
        public string audit { get; set; }
        /// <summary>
        /// 采购明细
        /// </summary>
        public List<RequestPurchaseToolsDetail> data { get; set; }
    }
    public class RequestPurchaseToolsDetail
    {
        /// <summary>
        /// 物料编号
        /// </summary>
        public string material_code { get; set; }
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; }
        /// <summary>
        /// 采购数量
        /// </summary>
        public string purchase_qty { get; set; }

    }

    /// <summary>
    /// 长龄刀具领用
    /// </summary>
    public class RequestAdoptTools
    {
        /// <summary>
        /// 出库单号
        /// </summary>
        public string outbound_number { get; set; }
        /// <summary>
        /// 出库类型
        /// 1原材入库      
        /// 2生产入库
        /// 3其他入库     
        /// 4生产领料
        /// 5销售出货       
        /// 6其他出库
        /// 7整刀入库       
        /// 8采购入库      
        /// 9回收入库
        /// 10领用出库
        /// </summary>
        public int outbound_type { get; set; } = 10;
        /// <summary>
        /// 出库仓库
        /// </summary>
        public string location { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public long create_time { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public string create_user { get; set; }
        /// <summary>
        /// 领用明细
        /// </summary>
        public List<RequestPurchaseToolsDetail> data { get; set; }
    }
}
