﻿

using Dapper;
using System;

namespace Siger.Middlelayer.Dapper
{
    public class ProjectRepository : DapperRepositoryBase
    {
        public ProjectRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public bool InitTables(string sql)
        {
            try
            {
                using (var conn = GetDbConnection())
                {
                    var ret = conn.Execute(sql);
                    if (ret == 0)
                    {
                        return false;
                    }
                }
            }
            catch
            {
                return false;
            }
            return true;
        }

        public bool InitDataBase(string name)
        {
            var sql = $"CREATE DATABASE `{name}` CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';";
            try
            {
                using (var conn = GetBaseDbConnection())
                {
                    var ret = conn.Execute(sql);
                    if (ret == 0)
                    {
                        return false;
                    }
                }
            }
            catch
            {
                return false;
            }
            return true;
        }

        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
