﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
namespace Siger.Middlelayer.Redis.RedisEntities
{
    [DataContract]
    public class CNCEquipmentState: RedisEntityBase
    {
        [DataMember(Name ="mn") ]
        public int MachineId { get; set; }

        [DataMember(Name = "status")]
        public int Status { get; set; }

        [DataMember(Name = "sl1")]
        public double SpindleLoad1 { get; set; }

        [DataMember(Name = "ss1")]
        public double SpindleSpeed1 { get; set; }

        [DataMember(Name = "sl2")]
        public double SpindleLoad2 { get; set; }

        [DataMember(Name = "ss2")]
        public double SpindleSpeed2 { get; set; }

        [DataMember(Name = "sl3")]
        public double SpindleLoad3 { get; set; }

        [DataMember(Name = "ss3")]
        public double SpindleSpeed3 { get; set; }

        [DataMember(Name = "sl4")]
        public double SpindleLoad4 { get; set; }

        [DataMember(Name = "ss4")]
        public double SpindleSpeed4 { get; set; }

        /// <summary>
        /// 进给速度  feedRate
        /// </summary>
        [DataMember(Name = "fre")]
        public double FeedSpeed { get; set; }

        /// <summary>
        /// 进给倍率   feedSpeedRatio
        /// </summary>
        [DataMember(Name = "fro")]
        public double FeedRatio { get; set; }

        /// <summary>
        /// 主轴倍率  spindleSpeedRatio
        /// </summary>
        [DataMember(Name = "sro")]
        public double SpindleRatio { get; set; }

        [DataMember(Name = "pn")]
        public string PN { get; set; }

        [DataMember(Name = "spn")]
        public string SPN { get; set; }

        [DataMember(Name = "time")]
        public string Time { get; set; }

        [DataMember(Name = "lastUpdateTime")]
        public string LastUpdateTime { get; set; }

        /// <summary>
        /// 设备刀具号（）
        /// </summary>
        [DataMember(Name = "tn")]
        public int ToolNo { get; set; }
        /// <summary>
        /// 设备刀具额定寿命
        /// </summary>
        [DataMember(Name = "tl")]
        public int ToolLife { get; set; }
        /// <summary>
        /// 设备刀具使用寿命
        /// </summary>
        [DataMember(Name = "tc")]
        public int ToolUage { get; set; }

        [DataMember(Name = "tn1")]
        public int Tn1 { get; set; }

        [DataMember(Name = "tn2")]
        public int Tn2 { get; set; }

        [DataMember(Name = "tn3")]
        public int Tn3 { get; set; }

        [DataMember(Name = "tn4")]
        public int Tn4 { get; set; }
    }
}
