﻿using System;
using System.Runtime.Serialization;
namespace Siger.Middlelayer.Redis.RedisEntities
{
    /// <summary>
    /// 设备出现过的程序号列表 
    /// Redis: JK_ProgramList
    /// Type:Zset
    /// key:unixtime 
    /// </summary>
    [DataContract]
    public class ProgramList : RedisEntityBase
    {
        /// <summary>
        /// 时间
        /// </summary>
        [DataMember(Name = "t")]
        public string ChangeTime { get; set; }

        /// <summary>
        /// 设备ID 
        /// </summary>
        [DataMember(Name = "mn")]
        public int MachineId { get; set; }

        /// <summary>
        /// 主程序
        /// </summary>
        [DataMember(Name = "pn")]
        public string ProgramNo { get; set; }

        /// <summary>
        /// 子程序
        /// </summary>
        [DataMember(Name = "spn")]
        public string SubProgramNo { get; set; }

        /// <summary>
        /// 主轴名称
        /// </summary>
        [DataMember(Name = "spindle")]
        public string SpindleName { get; set; }

        /// <summary>
        /// 刀位名称
        /// </summary>
        [DataMember(Name = "tn")]
        public string ToolName { get; set; }

        /// <summary>
        /// 程序状态
        /// </summary>
        [DataMember(Name = "pst")]
        public int ProgramState { get; set; }
    }
}
