﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class AlarmRulesConfigRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public AlarmRulesConfigRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        /// <summary>
        /// 设置非故障代码
        /// </summary>
        /// <returns></returns>
        public void SetFaultCode(int machineId, string code, int value)
        {
            try
            {
                Client.HSet(HashAlarmRulesConfig, $"{machineId}_{code}", value);
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
