﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;
namespace Siger.Middlelayer.Redis.Repositories
{
    public class CCInitializeConfigRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public CCInitializeConfigRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        /// <summary>
        /// 保存CC 切分类型
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="spindle"></param>
        /// <param name="cuterNo"></param>
        /// <param name="program"></param>
        /// <param name="config"></param>
        public void SetCCmode(int machineId, string spindle,string cuterNo,string program,CCInitializeConfig config)
        {
            try
            {
                var filed = $"{ machineId}_{program}_{spindle}_{cuterNo}";

                Client.HSet(HashTMSToolCCInitializeConfig, filed, config);
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }
        /// <summary>
        /// 获取 CC 切分类型
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="pn"></param>
        /// <param name="spindle"></param>
        /// <param name="cuterNo"></param>
        /// <returns></returns>
        public CCInitializeConfig GetCycleModeInit(int machineId, string pn, string spindle, string cuterNo)
        {
            //redis 
            var filed = $"{ machineId}_{pn}_{spindle}_{cuterNo}";
            try
            {
                var data = Client.HGet(HashTMSToolCCInitializeConfig, filed);
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<CCInitializeConfig>(data);
                }
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return null;
        }
        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
