﻿using Siger.Middlelayer.Redis.RedisEntities;
using System;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.Model;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class ChangeToolRepository: RedisRepositoryBase
    {
        private readonly bool _dispose;
        public ChangeToolRepository(int companyId, int projectId, bool dispose = true): base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void Dispose()
        {
            Client?.Dispose();
        }

        public void AddChangeToolsRecord(RedisChangeRecordModel record,DateTime actime)
        {
            var redisEntity = new ChangeToolsRecord
            {
                MachineId = record.machine_id,
                RatedLife = record.rating_life ?? 0,
                ProgramNo = record.programno,
                SpindleName = record.mainaxis,
                Reason = record.change_reason,
                ToolName = record.tool_no,
                ChangeTime = record.change_time,
                actual_t=actime.ToString(UnixTimeHelper.DateTimeFormat),
                Create_t=DateTime.Now.ToString(UnixTimeHelper.DateTimeFormat)
            };

            try
            {
                var score = GetToolChangeScore(record);

                Client.ZAdd(ZSetChangeToolsRecordName, (score, JsonHelper.SerializerToJsonString(redisEntity)));
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void UpdateChangeToolsRecord(RedisChangeRecordModel originalRecord, RedisChangeRecordModel newRecord,DateTime actime)
        {
            try
            {
                var score = GetToolChangeScore(originalRecord);
                Client.ZRem(ZSetChangeToolsRecordName, score);
           
                AddChangeToolsRecord(newRecord,actime);
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }

        public void DeleteChangeToolsRecord(RedisChangeRecordModel record)
        {
            try
            {
                var score = GetToolChangeScore(record);

                Client.ZRem(ZSetChangeToolsRecordName, score);
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }

        public void MergeChangeToolsRecord(RedisChangeRecordModel record)
        {
            var score = GetToolChangeScore(record);

            Client.ZRem(ZSetChangeToolsRecordName, score);

            AddChangeToolsRecord(record,DateTime.Now);
        }

        private long GetToolChangeScore(RedisChangeRecordModel record)
        {
            //score = mn+spindle+tn+t
            var scoreStr = $"{record.machine_id}{record.mainaxis}{record.tool_no}{record.change_time}";
            return long.Parse(scoreStr);
        }
    }
}
