﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Siger.Middlelayer.Redis.RedisEntities;
using Newtonsoft.Json;
namespace Siger.Middlelayer.Redis.Repositories
{
    public class ProgramListRepository : RedisRepositoryBase
    {
        private int _companyId;
        private int _projectId;
        public ProgramListRepository(int companyId, int projectId) : base(companyId, projectId)
        {
            _companyId = companyId;
            _projectId = projectId;
        }

        /// <summary>
        /// 获取一段分值的数据
        /// </summary>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        public ProgramList GetRunningProgram(long start,long end)
        {
            try
            {
                var data = Client.ZRangeByScore(ZSetProgramlist,start,end);
                if (data.Length > 0)
                {
                    var topData = data[data.Length - 1];
                    if (!string.IsNullOrEmpty(topData))
                    {
                        return JsonConvert.DeserializeObject<ProgramList>(topData);
                    }
                }
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                Client?.Dispose();
            }
            return null;
        }

        /// <summary>
        /// 获取所有数据
        /// </summary>
        /// <returns></returns>
        public IEnumerable<ProgramList> GetRunningPrograms()
        {
            try
            {
                var programs = Client.HGetAll<ProgramList>(ZSetProgramlist);
                return programs.Values;
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }
    }
}
