﻿using System;
using System.IO;
using System.Security.Cryptography;
using System.Text;
using Siger.Middlelayer.License.Models;

namespace Siger.Middlelayer.License.Utilities
{
    public class DesBuilder
    {
        private const string EncryptKey = "Sg#li018";
        private static readonly byte[] Keys = { 0x12, 0x78, 0x56, 0x31, 0x6F, 0x6A, 0x25, 0x7A };

        /// <summary>
        /// 加密
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static string Encrypt(string value)
        {
            if (string.IsNullOrEmpty(value)) return string.Empty;
            try
            {
                byte[] rgbKey = Encoding.UTF8.GetBytes(EncryptKey);
                byte[] rgbIv = Keys;
                byte[] inputByteArray = Encoding.UTF8.GetBytes(value);
                var dCsp = new DESCryptoServiceProvider();
                using (var stream = new MemoryStream())
                {
                    using (var cStream = new CryptoStream(stream, dCsp.CreateEncryptor(rgbKey, rgbIv), CryptoStreamMode.Write))
                    {
                        cStream.Write(inputByteArray, 0, inputByteArray.Length);
                        cStream.FlushFinalBlock();
                        var output = Convert.ToBase64String(stream.ToArray());
                        return output;
                    }
                }
            }
            catch
            {
                return value;
            }
        }

        public static string GenerationExpityTime(string id)
        {
            var expityTime = (ExpiryCategory)Enum.Parse(typeof(ExpiryCategory), id);
            var value = string.Empty;
            switch (expityTime)
            {
                case ExpiryCategory.OneMonth:
                    value = "3947367637C448A39AFB5B8AAE91E498";
                    break;
                case ExpiryCategory.ThreeMonth:
                    value = "E1A547F7F6CD42429388D17DCD882CB3";
                    break;
                case ExpiryCategory.SixMonth:
                    value = "6429C5A2190446758A6C0615FD576ECC";
                    break;
                case ExpiryCategory.OneYear:
                    value = "5B499D85EE8B4A89A90B3BF3C37344EC";
                    break;
                case ExpiryCategory.TwoYear:
                    value = "5154D6D90F774ECFB464A4BA3F8C6F7A";
                    break;
                case ExpiryCategory.ThreeYear:
                    value = "CEE6431D18804AF089CC88C8EDA3E737";
                    break;
                case ExpiryCategory.FiveYear:
                    value = "D7504260E3E64D8D8FA2678BB2785249";
                    break;
                case ExpiryCategory.Never:
                    value = "B5C4CBFF7BB54CBBBBC1D1638D7D3FBD";
                    break;
            }

            return value;
        }
    }
}
