﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace Siger.Middlelayer.License.Utilities
{
    public class EnumberHelper
    {
        public static List<EnumberEntity> EnumToList<T>()
        {
            var list = new List<EnumberEntity>();

            foreach (var e in Enum.GetValues(typeof(T)))
            {
                EnumberEntity m = new EnumberEntity();
                object[] objArr = e.GetType().GetField(e.ToString()).GetCustomAttributes(typeof(DescriptionAttribute), true);
                if (objArr.Length > 0)
                {
                    DescriptionAttribute da = objArr[0] as DescriptionAttribute;
                    m.Description = da.Description;
                }
                m.EnumValue = Convert.ToInt32(e);
                m.EnumName = e.ToString();
                list.Add(m);
            }
            return list;
        }
    }

    public class EnumberEntity
    {
        /// <summary>  
        /// 枚举的描述  
        /// </summary>  
        public string Description { set; get; }

        /// <summary>  
        /// 枚举名称  
        /// </summary>  
        public string EnumName { set; get; }

        /// <summary>  
        /// 枚举对象的值  
        /// </summary>  
        public int EnumValue { set; get; }
    }

    public enum Module
    {
        /// <summary>
        /// 追溯服务
        /// </summary>
        Mts,
        /// <summary>
        /// 数字化工厂服务
        /// </summary>
        Cnc,
        /// <summary>
        /// DNC 服务
        /// </summary>
        Dnc,
        /// <summary>
        /// 刀具服务
        /// </summary>
        Tms,
        /// <summary>
        /// 仓库管理系统
        /// </summary>
        Wms,
        /// <summary>
        /// 设备智能管理
        /// </summary>
        Tpm,
        /// <summary>
        /// dashboard
        /// </summary>
        Dashboard,
    }
}
