# -*- coding: utf-8 -*-
import QMS_Engine as engine
import QMS_Visual as visual
import QMS_Algorithms as algory
import QMS_DynamicDiag as rule
import time
import json
import sys

def getTimeStringByUnixInt(unixTime):
        timeArray = time.localtime(unixTime)
        return time.strftime("%Y-%m-%d %H:%M:%S", timeArray)


def getRequestJsonString(argv):
        sTime = getTimeStringByUnixInt(int(argv[5]))
        eTime = getTimeStringByUnixInt(int(argv[6]))
        json1 = {
                        "setSection" : [argv[2]],
                        "setMachineID" : argv[3],
                        "setProductID" : argv[4],                        
                        "setStarttime" : sTime,
                        "setEndtime" : eTime,
                        "setTargetfeature" : argv[7],
                        "setChunkSize" : argv[8],
                        "setGroupSize" : argv[9],
                        "setGroupNum" : argv[10],
                }
        return json1


def requestInterface(jsonStr, methodName):
        if methodName == 'ActivatePlotControl':                
                engine.ActivatePlotControl(jsonStr)
        elif methodName == 'ActivatePlotMRControl':
                engine.ActivatePlotMRControl(jsonStr)
        elif methodName == 'ActivatePlotXbarControl':
                engine.ActivatePlotXbarControl(jsonStr)
        elif methodName == 'ActivatePlotXbarMRControl':
                engine.ActivatePlotXbarMRControl(jsonStr)
        elif methodName == 'ActivatePlotPControl':
                engine.ActivatePlotPControl(jsonStr)
        elif methodName == 'ActivatePlotUControl':
                engine.ActivatePlotUControl(jsonStr)
        elif methodName == 'ActivatePlotCorr':
                engine.ActivatePlotCorr(jsonStr)
        elif methodName == 'ActivatePlotCpk':
                engine.ActivatePlotCpk(jsonStr)
        elif methodName == 'ActivatePlotPpk':
                engine.ActivatePlotPpk(jsonStr)
        elif methodName == 'ActivatePlotObsCluster':
                engine.ActivatePlotObsCluster(jsonStr)
        elif methodName == 'ActivatePlotVarCluster':
                engine.ActivatePlotVarCluster(jsonStr)
        elif methodName == 'ActivatePlotXGBTree':
                engine.ActivatePlotXGBTree(jsonStr)
        elif methodName == 'ActivatePlotTS':
                engine.ActivatePlotTS(jsonStr)
        elif methodName == 'ActivatePlotProb':
                engine.ActivatePlotProb(jsonStr)
        elif methodName == 'ActivatePlotScatterGroup':
                engine.ActivatePlotScatterGroup(jsonStr)


def main(argv):
        if argv[1] == 'DynamicDiag':
                jsonData = {
                        "itemID": argv[2],
                        "UCL": argv[3],
                        "LCL": argv[4],
                        "traceID": argv[5],
                        "value": argv[6],
                        "rule1": argv[7],
                        "rule2": argv[8],
                        "rule3": argv[9],
                        "rule4": argv[10],
                        "rule5": argv[11],
                        "rule6": argv[12],
                        "rule7": argv[13],
                        "rule8": argv[14],
                }                                
                rule.DynamicDiag(jsonData)
        elif argv[1] == 'DynamicHistParams':
                jsonData = {
                        "itemID": argv[2],
                        "UCL": argv[3],
                        "LCL": argv[4],
                        "value": argv[5],
                }                                
                rule.DynamicHistParams(jsonData)
        else:
                jsonStr = getRequestJsonString(argv)
                requestInterface(jsonStr, argv[1])

if __name__ == "__main__":
        main(sys.argv)