using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.DependencyInjection;
using Siger.ApiCommon.Filters;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.TpmRepository;
using Siger.Middlelayer.Log;
using Xunit;

namespace Siger.Unit.Test.TPM
{
    public class DependencyInjectionTest
    {
        private string _corsKeyName = "Cors";
        [Fact]
        public void DI_Test()
        {
            IServiceCollection services = new ServiceCollection();
            services.AddCors(options => {
                options.AddPolicy(_corsKeyName, builder => builder.AllowAnyOrigin()
                .AllowAnyHeader().AllowAnyMethod());
                //.WithMethods("GET", "POST", "HEAD", "PUT", "DELETE", "OPTIONS")) ;
            });
            services.AddMvc(option => option.EnableEndpointRouting = false).SetCompatibilityVersion(CompatibilityVersion.Version_3_0).AddJsonOptions(o =>
            {
                o.JsonSerializerOptions.Converters.Add(new DateTimeConverter());
            });
            services.AddMvc(options =>
            {
                options.Filters.Add<ModelValidateFilter>();
                options.Filters.Add<ApiExceptionFilter>();
                options.Filters.Add<ResultFilter>();
                options.Filters.Add<TokenValidateFilter>();
            });
            Logger.RegisterLogEngine(Module.Tpm);
            Swagger.AddSwagger(services, Module.Tpm);
            TpmRepositoryFactory.Instance.Initialization(services);
            Cors.AddCors(services);
            Assert.True(services.Count > 0);
        }
        public ServiceProvider Init()
        {
            IServiceCollection services = new ServiceCollection();
            services.AddMvc(option => option.EnableEndpointRouting = false).SetCompatibilityVersion(CompatibilityVersion.Version_3_0).AddJsonOptions(o =>
            {
                o.JsonSerializerOptions.Converters.Add(new DateTimeConverter());
            });
            services.AddMvc(options =>
            {
                options.Filters.Add<ModelValidateFilter>();
                options.Filters.Add<ApiExceptionFilter>();
                options.Filters.Add<ResultFilter>();
                options.Filters.Add<TokenValidateFilter>();
            });
            Logger.RegisterLogEngine(Module.Tpm);
            Swagger.AddSwagger(services, Module.Tpm);
            TpmRepositoryFactory.Instance.Initialization(services);
            Cors.AddCors(services);
            return services.BuildServiceProvider();
        }
    }
}
