﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace SugarDemo
{
    public class SugarHelper
    {
        public static SqlSugarClient DB
        {
            get => new SqlSugarClient(new ConnectionConfig
            {
                ConfigId = "Siger",
                ConnectionString = "Server=172.8.10.141; Port=3306;Stmt=; Database=skfpd0505; Uid=root; Pwd=Siger_123;",
                DbType = DbType.MySql,
                IsAutoCloseConnection = true,
                IsShardSameThread = false,
                MoreSettings = new ConnMoreSettings()
                {
                    IsAutoRemoveDataCache = true
                }
            });
        }
        public void InitFile(BaseEntityData settings)
        {
            
            CreateRepository(settings);
            CreateIRepository(settings);
            CreateEntities(settings);
        }

        private void CreateRepository(BaseEntityData condition)
        {
            var idbFirst = DB.DbFirst;
            if (condition.listTable != null && condition.listTable.Length > 0)
            {
                idbFirst = idbFirst.Where(condition.listTable);
            }
            idbFirst.SettingClassTemplate(old =>
            old = $@"
using {condition.strNamespace}.Entities;
using {condition.strNamespace}.Repositories.Interface;
namespace " + condition.strNamespace + @".Repositories
{
    /// <summary>
	/// {ClassName}Repository
	/// </summary>
    internal class {ClassName}Repository : " + condition.strBaseRepository + @"<{ClassName}>, I{ClassName}Repository
    {
        public {ClassName}Repository() : base()
        {
        }
    }
}
                    ").CreateClassFile(Path.Combine(condition.strPath, "Repository"), condition.strNamespace);

        }

        private void CreateIRepository(BaseEntityData condition)
        {
            var idbFirst = DB.DbFirst;
            if (condition.listTable != null && condition.listTable.Length > 0)
            {
                idbFirst = idbFirst.Where(condition.listTable);
            }
            idbFirst.SettingClassTemplate(old =>
            old = $@"
using {condition.strNamespace}.Entities;
using {condition.strNamespace}.Repositories;

namespace " + condition.strNamespace + @".Repositories.Interface
{
    /// <summary>
	/// {ClassName}Repository
	/// </summary>
    public interface I{ClassName}Repository : I" + condition.strBaseRepository + @"<{ClassName}>
    {
        
    }
}
                    ").CreateClassFile(Path.Combine(condition.strPath, "Interface"), condition.strNamespace);
        }

        private void CreateEntities(BaseEntityData condition)
        {
            var idbFirst = DB.DbFirst;
            if (condition.listTable != null && condition.listTable.Length > 0)
            {
                idbFirst = idbFirst.Where(condition.listTable);
            }
            idbFirst.SettingClassTemplate(old =>
            old = @"
namespace " + condition.strNamespace + @".Entities
{
	{ClassDescription}{SugarTable}
    public class {ClassName} : " + condition.strBaseEntity + @"
    {
        public {ClassName}()
        {
        }
        {PropertyName}
    }
}
                    ").SettingPropertyTemplate(old => old = @"
        {SugarColumn}
        public {PropertyType} {PropertyName} { get; set; }

            ").CreateClassFile(Path.Combine(condition.strPath, "Entities"), condition.strNamespace);

        }
    }
}
