﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Common.Extensions;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace Siger.ApiACC.Controllers
{
    [Route("acc/[controller]/[action]")]
    public class LaisiBaseController
    {
        /// <summary>
        /// 自动线 ProjectID 通过配置
        /// </summary>
        public int PID = 0;
        public LaisiBaseController()
        {
            var _pid = ConfigManager.GetValue("ProjectSetting", "ProjectId", string.Empty);
            if (string.IsNullOrEmpty(_pid))
                throw new Exception("DbSetting about [ProjectSetting] ProjectId not found.");
            PID = _pid.ToInt();
        }
    }
}
