﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Extensions;
using System.Linq;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiACC.Controllers
{
    public class SectionPropertyController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IAutomationSectionPropertyRepository _sectionPropertyRepository;
        private readonly ISigerProjectLevelSectionRepository _levelSectionRepository;
        private readonly IProductionBeatSetRepository _beatSetRepository;
        private readonly IAutomationFixtureMonitor _fixtureMonitor;

        public SectionPropertyController(IUnitOfWork unitOfWork, IAutomationSectionPropertyRepository sectionPropertyRepository,
            ISigerProjectLevelSectionRepository levelSectionRepository, IProductionBeatSetRepository beatSetRepository,
            IAutomationFixtureMonitor fixtureMonitor)
        {
            _unitOfWork = unitOfWork;
            _sectionPropertyRepository = sectionPropertyRepository;
            _levelSectionRepository = levelSectionRepository;
            _beatSetRepository = beatSetRepository;
            _fixtureMonitor = fixtureMonitor;
        }

        [HttpGet]
        public IActionResult GetSections(string line)
        {
            var sectionIds = _levelSectionRepository.GetLevelSectionIds(line.ToInt(), ProjectId);
            var sectionids = _sectionPropertyRepository.GetList(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && sectionIds.Contains(q.sectionid)).
                Select(q => q.sectionid).ToList();
            var sections = _levelSectionRepository.GetList(q => q.projectid == ProjectId && q.status == (int)RowState.Valid && sectionids.Contains(q.id)).
                Select(q => new { q.id, q.title }).ToList();
            return new ObjectResult(sections);
        }

        [HttpGet]
        public IActionResult GetRouteByProduct(string productId, int sectionId)
        {
            var list = _beatSetRepository.GetList(q => q.projectID == ProjectId && q.status == (int)RowState.Valid && q.product_name.ToInt() == productId.ToInt() &&
                q.section_id == sectionId).Select(q => new
                {
                    q.id,
                    name = q.route_name,
                    q.route_number
                }).ToList();

            return new ObjectResult(list);
        }

        [HttpGet]
        public IActionResult GetSn(int sectionid)
        {
            var monitor = _fixtureMonitor.GetList(q => q.projectId == ProjectId && q.status == (int)RowState.Valid && q.section == sectionid).OrderByDescending(q => q.updatetime).
                FirstOrDefault();
            return new ObjectResult(monitor?.sn ?? "");
        }
    }
}
