﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;

namespace Siger.ApiConfig.Controller
{
    public class IndustryController : BaseController
    {
        private readonly ISigerIndustryFirstRepository _firstRepository;
        private readonly ISigerIndustrySecondRepository _secondRepository;
        public IndustryController(ISigerIndustryFirstRepository firstRepository, ISigerIndustrySecondRepository secondRepository)
        {
            _firstRepository = firstRepository;
            _secondRepository = secondRepository;
        }

        [HttpGet]
        public IActionResult GetIndustryFirst()
        {
            var response = new List<ResponseIdName>();

            var firsts = _firstRepository.GetList(q => q.status == (int)RowState.Valid);
            foreach (var first in firsts)
            {
                response.Add(new ResponseIdName { id = first.id, name = first.name });
            }

            return new ObjectResult(response);
        }

        [HttpGet]
        public IActionResult GetIndustrySecond(int firstid)
        {
            var response = new List<ResponseIdName>();

            var firsts = _secondRepository.GetList(q => q.status == (int)RowState.Valid && q.firstid == firstid);
            foreach (var first in firsts)
            {
                response.Add(new ResponseIdName { id = first.id, name = first.name });
            }

            return new ObjectResult(response);
        }
    }
}