﻿-- ----------------------------
-- Table structure for CNC_AlarmAnalysresult
-- ----------------------------
DROP TABLE IF EXISTS `CNC_AlarmAnalysresult`;
CREATE TABLE `CNC_AlarmAnalysresult` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `source` int DEFAULT NULL,
  `Stime` datetime DEFAULT NULL,
  `set` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `level` int DEFAULT NULL,
  `message` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `Etime` datetime DEFAULT NULL,
  `status` int DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `FaultContent` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `FaultReason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `FaultSolution` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `Remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `IsFault` int DEFAULT '1' COMMENT '是否故障类报警',
  `MarkTime` datetime DEFAULT NULL COMMENT '标定时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_AlarmAnalysresult_bak
-- ----------------------------
DROP TABLE IF EXISTS `CNC_AlarmAnalysresult_bak`;
CREATE TABLE `CNC_AlarmAnalysresult_bak` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `source` int DEFAULT NULL,
  `Stime` datetime DEFAULT NULL,
  `set` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `level` int DEFAULT NULL,
  `message` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `Etime` datetime DEFAULT NULL,
  `status` int DEFAULT NULL,
  `FaultContent` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `FaultReason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `FaultSolution` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `Remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `IsFault` int DEFAULT '1' COMMENT '是否故障类报警',
  `MarkTime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '标定时间',
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_DailySliceSate
-- ----------------------------
DROP TABLE IF EXISTS `CNC_DailySliceSate`;
CREATE TABLE `CNC_DailySliceSate` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `machineID` int NOT NULL,
  `run` double DEFAULT '0',
  `debug` double DEFAULT '0',
  `free` double DEFAULT '0',
  `fault` double DEFAULT '0',
  `shutdown` double DEFAULT '0',
  `changeline` double DEFAULT NULL,
  `switchStatus` int DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_DailySliceSate_bak
-- ----------------------------
DROP TABLE IF EXISTS `CNC_DailySliceSate_bak`;
CREATE TABLE `CNC_DailySliceSate_bak` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `machineID` int NOT NULL,
  `run` double DEFAULT '0',
  `debug` double DEFAULT '0',
  `free` double DEFAULT '0',
  `fault` double DEFAULT '0',
  `shutdown` double DEFAULT '0',
  `changeline` double DEFAULT NULL,
  `switchStatus` int DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_ExceptionParamsSate
-- ----------------------------
DROP TABLE IF EXISTS `CNC_ExceptionParamsSate`;
CREATE TABLE `CNC_ExceptionParamsSate` (
  `id` int NOT NULL AUTO_INCREMENT,
  `MachineID` int NOT NULL DEFAULT '0',
  `Indexs` bigint NOT NULL DEFAULT '0',
  `Spindle` int DEFAULT NULL,
  `StartTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Type` int DEFAULT NULL,
  `Values` int DEFAULT NULL,
  `Uplimit` int DEFAULT NULL,
  `Downlimit` int DEFAULT NULL,
  `TotalSecond` int DEFAULT NULL,
  `Closed` int DEFAULT NULL,
  `EndTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_ExceptionParamsSate_bak
-- ----------------------------
DROP TABLE IF EXISTS `CNC_ExceptionParamsSate_bak`;
CREATE TABLE `CNC_ExceptionParamsSate_bak` (
  `id` int NOT NULL AUTO_INCREMENT,
  `MachineID` int NOT NULL DEFAULT '0',
  `Indexs` bigint NOT NULL DEFAULT '0',
  `Spindle` int DEFAULT NULL,
  `StartTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Type` int DEFAULT NULL,
  `Values` int DEFAULT NULL,
  `Uplimit` int DEFAULT NULL,
  `Downlimit` int DEFAULT NULL,
  `TotalSecond` int DEFAULT NULL,
  `Closed` int DEFAULT NULL,
  `EndTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_Production
-- ----------------------------
DROP TABLE IF EXISTS `CNC_Production`;
CREATE TABLE `CNC_Production` (
  `id` int NOT NULL AUTO_INCREMENT,
  `machineID` int NOT NULL DEFAULT '0' COMMENT '设备ID',
  `yield` int DEFAULT '0' COMMENT '产量',
  `programCode` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '程序号',
  `comment` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '程序备注',
  `StartTime` datetime DEFAULT NULL COMMENT 'cc开始时间',
  `EndTime` datetime DEFAULT NULL COMMENT 'cc结束时间',
  `dataTime` datetime DEFAULT NULL COMMENT '数据插入时间',
  `status` int DEFAULT '1',
  `CycleTime` double DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_Production_bak
-- ----------------------------
DROP TABLE IF EXISTS `CNC_Production_bak`;
CREATE TABLE `CNC_Production_bak` (
  `id` int NOT NULL AUTO_INCREMENT,
  `machineID` int NOT NULL DEFAULT '0',
  `yield` int DEFAULT '0' COMMENT '产量',
  `programCode` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '程序号',
  `comment` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '程序备注',
  `StartTime` datetime DEFAULT NULL COMMENT 'cc开始时间',
  `EndTime` datetime DEFAULT NULL COMMENT 'cc结束时间',
  `dataTime` datetime DEFAULT NULL COMMENT '数据插入时间',
  `status` int DEFAULT '1',
  `CycleTime` double DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_SliceSate
-- ----------------------------
DROP TABLE IF EXISTS `CNC_SliceSate`;
CREATE TABLE `CNC_SliceSate` (
  `id` int NOT NULL AUTO_INCREMENT,
  `MachineID` int NOT NULL DEFAULT '0',
  `Indexs` bigint NOT NULL DEFAULT '0',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Status` int DEFAULT NULL,
  `ProgramNum` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `IsExist` int DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `WordingModeId` int DEFAULT '0',
  `WordingName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '工作模式名称',
  `UserName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `Remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `IsException` int DEFAULT '0' COMMENT '是否异常，0：正常1：异常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_SliceSate_bak
-- ----------------------------
DROP TABLE IF EXISTS `CNC_SliceSate_bak`;
CREATE TABLE `CNC_SliceSate_bak` (
  `id` int NOT NULL AUTO_INCREMENT,
  `MachineID` int NOT NULL DEFAULT '0',
  `Indexs` bigint NOT NULL DEFAULT '0',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Status` int DEFAULT NULL,
  `ProgramNum` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `IsExist` int DEFAULT NULL,
  `UpdateTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `WordingModeId` int DEFAULT '0',
  `WordingName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '工作模式名称',
  `UserName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `Remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `IsException` int DEFAULT '0' COMMENT '是否异常，0：正常1：异常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_YieldNum
-- ----------------------------
DROP TABLE IF EXISTS `CNC_YieldNum`;
CREATE TABLE `CNC_YieldNum` (
  `id` int NOT NULL AUTO_INCREMENT,
  `machineID` int NOT NULL DEFAULT '0',
  `programCode` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '程序号',
  `yieldNum` int DEFAULT '0' COMMENT '昨日产量数',
  `endTime` date DEFAULT NULL COMMENT 'cc结束时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';

-- ----------------------------
-- Table structure for CNC_YieldNum_bak
-- ----------------------------
DROP TABLE IF EXISTS `CNC_YieldNum_bak`;
CREATE TABLE `CNC_YieldNum_bak` (
  `id` int NOT NULL AUTO_INCREMENT,
  `machineID` int NOT NULL DEFAULT '0',
  `programCode` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '程序号',
  `yieldNum` int DEFAULT '0' COMMENT '昨日产量数',
  `endTime` date DEFAULT NULL COMMENT 'cc结束时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='NDB_TABLE=READ_BACKUP=1';
