﻿using FluentScheduler;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Redis;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiConfig.Task
{
    public class MachineNodeJob : IJob
    {
        private readonly ApiConfigDbContext _context;
        public MachineNodeJob()
        {
            _context = new ApiConfigDbContext();
        }
        public void Execute()
        {
            try
            {
                var dbConfigs = RedisCache.Instance.GetDbNameConfigs();
                var start = UnixTimeHelper.GetTodayUnix();
                var end = start + 86400;
                var nodes = EnumHelper.EnumToList<MachineNodeName>().Where(f => f.EnumValue < 4);
                var node_name = nodes.Select(s => s.EnumValue).ToList();
                foreach (var config in dbConfigs)
                {
                    var pid = config.Pid;
                    //检查是否已经执行过当前脚本
                    var checkData = _context.siger_project_machine_node.Where(f => f.projectid.Equals(pid) && f.status == (int)RowState.Valid && node_name.Contains(f.node_name));
                    if (checkData.Any())
                    {
                        var max = checkData.Max(m => m.node_time);
                        start = (int)max;
                    }
                    var insertModel = new List<siger_project_machine_node>();
                    var createList = _context.siger_project_machine.Where(f => f.projectid.Equals(pid) && f.status == (int)RowState.Valid && f.time > start && f.time <= end).ToList();
                    var repairList = _context.siger_project_repair.Where(f => f.projectid.Equals(pid) && f.status == (int)RowState.Valid && f.createtime > start && f.createtime <= end).ToList();
                    var signList = _context.siger_project_plan_sign.Where(f => f.projectid.Equals(pid) && f.status == (int)RowState.Valid && f.create_time > start && f.create_time <= end).ToList();
                    foreach (var node in nodes)
                    {
                        switch ((MachineNodeName)node.EnumValue)
                        {
                            case MachineNodeName.Create:
                                foreach (var item in createList)
                                {
                                    insertModel.Add(new siger_project_machine_node { node_time = item.time, node_name = node.EnumValue, node_info = node.Description, machine = item.id, node_operator = item.mid, projectid = pid });
                                }
                                break;
                            case MachineNodeName.Repair:
                                foreach (var item in repairList)
                                {
                                    insertModel.Add(new siger_project_machine_node { node_time = item.createtime, node_name = node.EnumValue, node_info = $"应急维修工单{item.id}", machine = item.machineid, node_operator = item.mid, projectid = pid });
                                }
                                break;
                            case MachineNodeName.Maintenance:
                                foreach (var item in signList)
                                {
                                    var itemModel = _context.siger_project_plan_item.Where(f => f.machineid.Equals(item.machine_id) && f.status == (int)RowState.Valid && f.projectid.Equals(pid)).ToList();
                                    var des = string.Empty;
                                    itemModel.ForEach(it => des += it?.content ?? "");
                                    insertModel.Add(new siger_project_machine_node { node_time = item.create_time, node_name = node.EnumValue, node_info = des, machine = item.machine_id, node_operator = item.create_mid, projectid = pid });
                                }
                                break;
                        }
                    }
                    _context.siger_project_machine_node.AddRange(insertModel);
                    _context.SaveChanges();
                }

            }
            catch (Exception ex)
            {
                Logger.WriteLineError($"MachineNodeJob Exception:{ex.Message}");
            }
        }
    }
}
