﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Request;

namespace Siger.ApiDashboard.Controllers
{
    public class DashboardCjrfStaticPageController : BaseController
    {
        private readonly IDeviceStatusSummaryDataRepository _deviceStatusSummaryDataRepository;
        public DashboardCjrfStaticPageController(IDeviceStatusSummaryDataRepository deviceStatusSummaryDataRepository)
        {
            _deviceStatusSummaryDataRepository = deviceStatusSummaryDataRepository;
        }

        [HttpPost]
        public IActionResult AddCjrfData([FromBody] RequestSigerTrCjrfList ret)
        {
            var result = _deviceStatusSummaryDataRepository.AddCjrf(ret, ProjectId);
            if (result)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpGet]
        public IActionResult GetAllCjrfData()
        {
            var result = _deviceStatusSummaryDataRepository.GetAllCjrf(ProjectId);
            return new ObjectResult(result);
        }
    }
}
