﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Request;
using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Share.Enum.ModuleEnum;
using Siger.ApiCommon.Filters;
using System.Linq.Expressions;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.DashboardRepository.Response;

namespace Siger.ApiDashboard.Controllers
{
    public class DashboardLevelController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IDashboardLevelRepository _dashboardLevelRepository;
        private readonly ISigerProjectLevelSectionRepository _projectLevelSection;
        private readonly IDashboardFactoryChanel _dashboardFactoryChanel;
        public DashboardLevelController(IUnitOfWork unitOfWork, IDashboardLevelRepository dashboardLevelRepository, ISigerProjectLevelSectionRepository sigerProjectLevelSection, IDashboardFactoryChanel factoryChanel)
        {
            _unitOfWork = unitOfWork;
            _dashboardLevelRepository = dashboardLevelRepository;
            _projectLevelSection = sigerProjectLevelSection;
            _dashboardFactoryChanel = factoryChanel;
        }
        
        /// <summary>
        /// 工厂 页面配置
        /// </summary>
        /// <param name="factoryLevel"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SaveFatoryConfig([FromBody]RequestFactoryLevel factoryLevel)
        {
            var obj = _dashboardLevelRepository.Get(f => f.ProjectId == ProjectId && f.PageType == (int)DashboardEnum.Fatory);
            if (obj==null)
            {
                _dashboardLevelRepository.Insert(new siger_dashboard_level_config
                {
                     PageType=(int)DashboardEnum.Fatory, 
                     ProjectId=ProjectId,
                     Column=factoryLevel.Pic,
                     Column2=factoryLevel.Product,
                     Column3=factoryLevel.PlanCount,
                     status=(int)RowState.Valid
                });
            }else
            {
                obj.Column = factoryLevel.Pic;
                obj.Column2 = factoryLevel.Product;
                obj.Column3 = factoryLevel.PlanCount;
                _dashboardLevelRepository.Update(obj);


            }
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                return new ObjectResult(CommonEnum.Fail);

        }
        /// <summary>
        /// 通道 页面配置
        /// </summary>
        /// <param name="requestChanelLevel"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SaveChanelConfig([FromBody]RequestChanelLevel requestChanelLevel)
        {
            var obj=_dashboardLevelRepository.Get(f=>f.ProjectId==ProjectId && f.Section== requestChanelLevel.Section && f.PageType == (int)DashboardEnum.Chanel);
            if (obj==null)
            {
                _dashboardLevelRepository.Insert(new siger_dashboard_level_config
                {
                    PageType = (int)DashboardEnum.Chanel,
                    EmplCount=requestChanelLevel.EmplCount, 
                    Schedu=requestChanelLevel.Schedu,
                    ProjectId = ProjectId,
                    Section=requestChanelLevel.Section, 
                    Startime=requestChanelLevel.StartTime,
                    status = (int)RowState.Valid,
                    Column4=requestChanelLevel.Column4.ToStr(),
                    CurrentDate = requestChanelLevel.Date.ToDateTime(),
                    UpdateTime = UnixTimeHelper.GetNow()
                });
            }
            else
            {
                obj.EmplCount = requestChanelLevel.EmplCount;
                obj.Startime = requestChanelLevel.StartTime;
                obj.Schedu = requestChanelLevel.Schedu;
                obj.Column4 = requestChanelLevel.Column4.ToStr();
                obj.CurrentDate = requestChanelLevel.Date.ToDateTime();
                obj.UpdateTime = UnixTimeHelper.GetNow();
                _dashboardLevelRepository.Update(obj);
            }

            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            return new ObjectResult(CommonEnum.Fail);
        }

        /// <summary>
        /// 安灯 动态看板 配置
        /// </summary>
        /// <param name="requestAndonLevel"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SaveAndonConfig([FromBody]RequestAndonLevel requestAndonLevel)
        {
            //var obj = _dashboardLevelRepository.Get(f => f.ProjectId == ProjectId && f.PageType == (int)DashboardEnum.Andon);
            //if (obj==null)
            //{
            //    _dashboardLevelRepository.Insert(new siger_dashboard_level_config {
            //        ProjectId=ProjectId,
            //        PageType=(int)DashboardEnum.Andon,
                   
            //    });
            //}else
            //{
            //    obj.Busidate = requestAndonLevel.Busidate;
            //}
            //if (_unitOfWork.Commit() > 0)
            //    return new ObjectResult(CommonEnum.Succefull);
            //else
            //    return new ObjectResult(CommonEnum.Fail);

            return new ObjectResult(CommonEnum.Succefull);
        }

        [HttpGet]
        public IActionResult GetLine()
        {
            var result = _dashboardFactoryChanel.GetDashboardChanel(ProjectId);
            if (result.Any())
                return new ObjectResult(result);
            throw new BadRequestException(CommonEnum.RecordNotFound);
        }
        [HttpGet]
        public IActionResult GetlevelCfg(DashboardEnum type, int section)
        {
            Expression<Func<siger_dashboard_level_config, bool>> Funsection = f => true;
            Expression<Func<siger_dashboard_level_config, bool>> FunTrue = f => true;
            if (section != 0)
            {
                Funsection = f => f.Section == section;
            }
            FunTrue = f => f.ProjectId == ProjectId && f.PageType == (int)type;
            var predicate = Funsection.And(FunTrue);
            var data = _dashboardLevelRepository.GetList(predicate).OrderByDescending(q => q.UpdateTime).FirstOrDefault();
            if (data != null)
            {
                if (string.IsNullOrEmpty(data.Column4))
                {
                    data.Column4 = "0";
                }
                var factories = _dashboardFactoryChanel.GetDashboardChanel(ProjectId);
                var factory = factories.FirstOrDefault(q => q.id == data.Section);
                var response = new ResponseDashboardlevelConfig
                {
                    section = data.Section,
                    column4 = data.Column4,
                    currentDate = (data.CurrentDate.HasValue == false || data.CurrentDate.Value == DateTime.MinValue) 
                        ? "" 
                        : data.CurrentDate.Value.ToString(ParameterConstant.DateFormat),
                    emplCount = data.EmplCount,
                    schedu = data.Schedu,
                    startime = data.Startime,
                    pic = factory != null ? factory.pic : 1,
                    section_name = factory != null ? factory.title : "",
                };
                return new ObjectResult(response);
            }
            throw new BadRequestException(CommonEnum.RecordNotFound);
        }
    }
}
