﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Request;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Share.Enum.ModuleEnum;

namespace Siger.ApiDashboard.Controllers
{
    
    public class DashboardTotalController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;
        private readonly ISigerProjectAutoCalculationTotal _sigerProjectAutoCalculationTotal;

        public DashboardTotalController(IUnitOfWork unitOfWork, ISigerProjectLevelSectionRepository sigerProjectLevelSection, ISigerProjectAutoCalculationTotal sigerProjectAutoCalculationTotal)
        {
            _unitOfWork = unitOfWork;
            _sigerProjectLevelSection = sigerProjectLevelSection;
            _sigerProjectAutoCalculationTotal = sigerProjectAutoCalculationTotal;
        }

        /// <summary>
        /// 获取分页数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult GetRate([FromBody] RequestTotalRate request)
        {
            var staions = _sigerProjectLevelSection.GetLevelSectionIds(request.section, ProjectId).Distinct().ToList();
            var datta = _sigerProjectAutoCalculationTotal.GetRateDataPagedList(staions, request.begin.ToDateTime(), request.end.ToDateTime(), 
                (DashboardTotalRate)request.type, ProjectId, request.page, request.pageSize);
            return new PagedObjectResult(datta.Data, datta.Total, request.page, request.pageSize);
        }

        /// <summary>
        /// 修改数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult UpdRate([FromBody] RequestTotalRecord request)
        {
            var obj = _sigerProjectAutoCalculationTotal.Get(f => f.id == request.id);
            if (obj == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            obj.numerator = request.actval;
            obj.denominator = request.targetval;
            obj.lastupdate = DateTime.Now;
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 获取数据
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult DownRate([FromBody]RequestTotalRate request)
        {
            var ids = new List<int> { request.section };
            var line = _sigerProjectLevelSection.GetList(f => f.parentid == request.section).Select(s => s.id).ToList();
            ids.AddRange(line);
            var datta = _sigerProjectAutoCalculationTotal.GetRateDataPagedList(ids, request.begin.ToDateTime(), request.end.ToDateTime(), 
                (DashboardTotalRate)request.type, ProjectId, request.page, request.pageSize);
            return new PagedObjectResult(datta.Data, datta.Total, request.page, request.pageSize);
        }
    }
}
