﻿using System.Collections.Generic;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Share.Models;

namespace Siger.ApiDashboard.Result
{
    /// <inheritdoc />
    public class DashBoardResult : CncResultBase
    {
        public string code { get; set; }

        public object data { get; set; }
    }

    /// <inheritdoc />
    public class Dashboard11Result : DashBoardResult
    {
        public FirstParameter first { get; set; }

        public List<SecondParameter> second { get; set; }

        /// <inheritdoc />
        public Dashboard11Result()
        {
            first = new FirstParameter();
            second = new List<SecondParameter>();
        }
    }

    /// <inheritdoc />
    public class Dashboard13Result : DashBoardResult
    {
        public string type { get; set; }

        public IList<string> x { get; set; }

        public Dictionary<int, OeeDetailEntity> y { get; set; }

        /// <inheritdoc />
        public Dashboard13Result()
        {
            type = "time";
            x = new List<string>();
            y = new Dictionary<int, OeeDetailEntity>();
        }
    }

    /// <inheritdoc />
    public class Dashboard14Result : DashBoardResult
    {
        public IList<MachineCanvasDataInfo> analysis { get; set; }

        public DashboardMachineRunningStateResult status { get; set; }

        /// <inheritdoc />
        public Dashboard14Result()
        {
            analysis = new List<MachineCanvasDataInfo>();
        }
    }

    /// <inheritdoc />
    public class DashboardListMachineYieldBySignResult : DashBoardResult
    {
        public IList<string> x { get; set; }

        public IList<int> y { get; set; }

        /// <inheritdoc />
        public DashboardListMachineYieldBySignResult()
        {
            x = new List<string>();
            y = new List<int>();
        }
    }

    /// <inheritdoc />
    public class DashboardMachineRunningStateResult : DashBoardResult
    {
        public string iszy { get; set; }

        public object zy_data { get; set; }

        public Dictionary<int, object> listAll { get; set; }

        public LastData last_data { get; set; }

        public Dictionary<string, object> police { get; set; }

        /// <inheritdoc />
        public DashboardMachineRunningStateResult()
        {
            listAll = new Dictionary<int, object>();
            last_data = new LastData();
            police = new Dictionary<string, object>();
        }
    }

    /// <inheritdoc />
    public class DashboardMachineRunningStateListResult : DashBoardResult
    {
        public int companyid { get; set; }

        public int projectid { get; set; }

        public string startTime { get; set; }

        public string endTime { get; set; }

        public object zy_data { get; set; }

        public string iszy { get; set; }

        public List<int> ids { get; set; }

        public List<int> machines { get; set; }

        public LastData last_data { get; set; }

        public new Dictionary<int, object> data { get; set; }

        public Dictionary<string, object> police { get; set; }

        /// <inheritdoc />
        public DashboardMachineRunningStateListResult()
        {
            ids = new List<int>();
            machines = new List<int>();
            data = new Dictionary<int, object>();
            last_data = new LastData();
            police = new Dictionary<string, object>();
        }
    }

    /// <inheritdoc />
    public class DashboardMachineCanvasParetoInfoResult : DashBoardResult
    {
        public string startTime { get; set; }

        public string endTime { get; set; }

        public double total_time_span { get; set; }

        public IList<Canvas> canvas { get; set; }

        public IList<Pareto> pareto { get; set; }

        public DashboardMachineCanvasParetoInfoResult()
        {
            canvas = new List<Canvas>();

            pareto = new List<Pareto>();
        }
    }

    public class DashboardDbProduction3List
    {
        public int Status { get; set; }

        public int machine_id { get; set; }

        public int x { get; set; }

        public int y { get; set; }

        public int w { get; set; }

        public int h { get; set; }

        public int machine_section_id { get; set; }

        public string machine_section_title { get; set; }

        public int production_section_id { get; set; }

        public string production_section_title { get; set; }

        public double time_lag { get; set; } //时间稼动率
    }

    /// <inheritdoc />
    public class DashboardProductionLine1Result : DashBoardResult
    {
        public DashboardMachineRunningStateResult status { get; set; }
    }

    /// <inheritdoc />
    public class DashboardProductionLine2Result : DashBoardResult
    {
        public EfficiencyOf eff { get;set;}

        public StatusTimeHours day { get; set; }

        public StatusTimeHours month { get; set; }

        public DashboardProductionLine2Result()
        {
            eff = new EfficiencyOf();
            day = new StatusTimeHours();
            month = new StatusTimeHours();
        }
    }

    public class StatusTimeHours
    {
        public double debugging { get; set; }
        public double fault { get; set; }
        public double free { get; set; }
        public double running { get; set; }
        public double shutdown { get; set; }
    }

    public class EfficiencyOf
    {
        public string big { get; set; }

        public string small { get; set; }
    }

    /// <inheritdoc />
    public class DashboardProductionLine4Result : DashBoardResult
    {
        public ProductionLine4 Day { get; set; }

        public ProductionLine4 OneYesterday { get; set; }

        public ProductionLine4 Yesterday { get; set; }

        /// <inheritdoc />
        public DashboardProductionLine4Result()
        {
            Day = new ProductionLine4();
            OneYesterday = new ProductionLine4();
            Yesterday = new ProductionLine4();
        }
    }

    public class ProductionLine4
    {
        public List<double> running { get; set; }

        public List<string> title { get; set; }

        /// <inheritdoc />
        public ProductionLine4()
        {
            running = new List<double>();
            title = new List<string>();
        }
    }

    /// <inheritdoc />
    public class DashboardProductionLine5 : DashBoardResult
    {
        public OneDayProductionLine5 dan { get; set; }

        public OneDayProductionLine5 level { get; set; }

        public List<MachineCanvasDataInfo> qie { get; set; }

        /// <inheritdoc />
        public DashboardProductionLine5()
        {
            dan = new OneDayProductionLine5();
            level = new OneDayProductionLine5();
            qie = new List<MachineCanvasDataInfo>();
        }
    }

    public class OneDayProductionLine5
    {
        public List<string> color { get; set; }

        public List<string> title { get; set; }

        public List<NameValue> running { get; set; }

        /// <inheritdoc />
        public OneDayProductionLine5()
        {
            color = new List<string>();
            title = new List<string>();
            running = new List<NameValue>();
        }
    }

    /// <inheritdoc />
    public class DashboardGaoboStatus1 : DashBoardResult
    {
        public DashboardMachineRunningStateResult status { get; set; }

        public List<MachineState> status2 { get; set; }

        /// <inheritdoc />
        public DashboardGaoboStatus1()
        {
            status2 = new List<MachineState>();
        }
    }

    /// <inheritdoc />
    public class DashboardAllProductLineResult : DashBoardResult
    {
        public string iszy { get; set; }

        public object zy_data { get; set; }

        public Dictionary<int, object> listAll { get; set; }

        public LastData last_data { get; set; }

        public Dictionary<int, List<DashboardDbProduction3List>> product { get; set; }

        /// <inheritdoc />
        public DashboardAllProductLineResult()
        {
            listAll = new Dictionary<int, object>();
            last_data = new LastData();
            product = new Dictionary<int, List<DashboardDbProduction3List>>();
        }
    }

    /// <inheritdoc />
    public class DashboardProductionBeatResult : DashBoardResult
    {
        public IList<ProductionBeat> product_list { get; set; }

        public string product_name_text { get; set; }

        public int daily_standard_output { get; set; }

        public double planNum { get; set; }

        public int productionNum { get; set; }

        public double YieldRate { get; set; }

        public string process_number { get; set; }

        /// <inheritdoc />
        public DashboardProductionBeatResult()
        {
            product_list = new List<ProductionBeat>();
        }
    }

    /// <inheritdoc>
    ///     <cref></cref>
    /// </inheritdoc>
    public class BeatTimeLeft
    {
        public string product_name_text { get; set; }

        public int daily_standard_output { get; set; }

        public double planNum { get; set; }

        public int productionNum { get; set; }

        public double YieldRate { get; set; }

        public string process_number { get; set; }

        public int yieldradio { get; set; }
    }

    /// <inheritdoc />
    public class ProductionBeat : DashboardDbProduction3List
    {
        public string besat { get; set; }
    }

    /// <inheritdoc />
    public class DashboardTimeGoResult : DashBoardResult
    {
        public DashboardProductionBeatResult _left { get; set; }

        public TimeGoRight _right { get; set; }

        /// <inheritdoc />
        public DashboardTimeGoResult()
        {
            _left = new DashboardProductionBeatResult();
            _right = new TimeGoRight();
        }
    }

    public class TimeGoRight
    {
        public IList<YieldNum> yieldNum { get; set; }

        public double OnAverage { get; set; }

        public TimeGoRight()
        {
            yieldNum = new List<YieldNum>();
        }
    }

    public class YieldNum
    {
        public int yield_num { get; set; }

        public int yield_time { get; set; }

        public int yield_title { get; set; }
    }

    /// <inheritdoc />
    public class DashboardWorkShopResult : DashBoardResult
    {
        public DashboardMachineRunningStateResult res_1 { get; set; }

        public DashboardProductionLine2Result res_2 { get; set; }

        public DashboardProductionLine4Result res_3 { get; set; }

        public MachineSateCount res_4 { get; set; }

        public WorkShop5 res_5 { get; set; }

        public DashboardWorkShopResult()
        {
            res_1 = new DashboardMachineRunningStateResult();
            res_2 = new DashboardProductionLine2Result();
            res_3 = new DashboardProductionLine4Result();
            res_4 = new MachineSateCount();
            res_5 = new WorkShop5();
        }
    }

    public class WorkShop5
    {
        public OneDayProductionLine5 month { get; set; }

        public OneDayProductionLine5 onemonth { get; set; }

        public WorkShop5()
        {
            month = new OneDayProductionLine5();
            onemonth = new OneDayProductionLine5();
        }
    }

    public class DashboardMachineCanvasParetoInfoPagedResult : DashBoardResult
    {
        public string startTime { get; set; }

        public string endTime { get; set; }

        public double total_time_span { get; set; }

        public IList<Canvas> canvas { get; set; }

        public IList<Pareto> pareto { get; set; }

        public int page { get; set; }

        public int pagesize { get; set; }

        public int total { get; set; }

        public DashboardMachineCanvasParetoInfoPagedResult()
        {
            canvas = new List<Canvas>();

            pareto = new List<Pareto>();
        }
    }
}
