﻿using Siger.Middlelayer.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Tasks
{
    internal class MachineStatusSummary
    {
        public double runtotal { get; set; }
        public double runaverage { get; set; }
        public double runpercent { get; set; }

        public double faulttotal { get; set; }
        public double faultaverage { get; set; }
        public double faultpercent { get; set; }

        public double idletotal { get; set; }
        public double idleaverage { get; set; }
        public double idlepercent { get; set; }

        public double debugtotal { get; set; }
        public double debugaverage { get; set; }
        public double debugpercent { get; set; }

        public double shutdowntotal { get; set; }
        public double shutdownaverage { get; set; }
        public double shutdownpercent { get; set; }


        public IList<StatusSummary> topgood { get; set; }

        public IList<StatusSummary> topbad { get; set; }

        public MachineStatusSummary()
        {
            topgood = new List<StatusSummary>();
            topbad = new List<StatusSummary>();
        }

        internal class StatusSummary
        {
            public string name { get; set; }

            public double run { get; set; }
        }

        internal class MachineStatusYield
        {
            public double total_rate { get; set; }

            public double free_rate { get; set; }

            public double debug_rate { get; set; }

            public double fault_rate { get; set; }

            public double shutdown_rate { get; set; }

            public IList<string> xdata { get; set; } = new List<string>();

            public IList<int> ydata { get; set; } = new List<int>();

            public IList<MachineStatusCount> data { get; set; } = new List<MachineStatusCount>();
        }

        internal class MachineStatusCount
        {
            public string location { get; set; }

            public string program_no { get; set; }

            public string product_name { get; set; }

            public string route_name { get; set; }

            public string theory_yield { get; set; }

            public double actual_output { get; set; }

            public string total_efficiency { get; set; }

            public string idle_loss { get; set; }

            public string debug_loss { get; set; }

            public string fault_loss { get; set; }

            public string shutdown_loss { get; set; }
        }

        internal class MachineQualityYieldResult
        {
            public string Product_Name { get; set; }

            public IList<MachineQualityYield> QualityYields { get; set; } = new List<MachineQualityYield>();

            public IList<string> yeild_xAxis { get; set; } = new List<string>();

            public IList<double> yeild_series { get; set; } = new List<double>();

            public IList<MachineNotYield> NotYields { get; set; } = new List<MachineNotYield>();

            public IList<ValueName> Notyeild_series { get; set; } = new List<ValueName>();

            public IList<string> Notyield_names { get; set; } = new List<string>();
        }

        internal class MachineQualityYield
        {
            public string sectionname { get; set; }

            public double inputnum { get; set; }

            public double oknum { get; set; }

            public double noknum { get; set; }

            public double healthyrate { get; set; }
        }

        internal class MachineNotYield
        {
            public string sectionname { get; set; }

            public double noknum { get; set; }
        }

        internal class TopOeeCalculate
        {
            public IList<string> oee_top5_yAxis { get; set; } = new List<string>();

            public IList<double> oee_top5_series { get; set; } = new List<double>();

            public double TotalOee { get; set; }

            public double LastMouthOee { get; set; }

            public string OptimalDay { get; set; }

            public double OptimalOee { get; set; }

            public string WorstDay { get; set; }

            public double WorstOee { get; set; }

            public double IncreaseOee { get; set; }

            public double IncreasePercent { get; set; }
        }

        internal class DayOee
        {
            public string day { get; set; }

            public double oee { get; set; }
        }

        internal class MouthOeeTimeResult
        {
            public IList<double> month_series_last { get; set; } = new List<double>();

            public IList<double> month_series_this { get; set; } = new List<double>();

            public IList<RunStatusOeeTime> MouthOeeTime { get; set; } = new List<RunStatusOeeTime>();

            public double TotalOeeTime { get; set; }

            public double IncreaseOeeTime { get; set; }

            public double IncreasePercent { get; set; }
        }

        internal class RunStatusOeeTime
        {
            public MachineRunningStatus RunStatus { get; set; }

            public string StatusName { get; set; }

            public double TimeCount { get; set; }

            public double TimePercent { get; set; }

            public double LastMouthPercent { get; set; }

            public double IncreaseLastMouth { get; set; }
        }

        internal class MachineStatusAverage
        {
            public double run_rate { get; set; }

            public double free_rate { get; set; }

            public double debug_rate { get; set; }

            public double fault_rate { get; set; }

            public double shutdown_rate { get; set; }

            public double run_time { get; set; }

            public double free_time { get; set; }

            public double debug_time { get; set; }

            public double fault_time { get; set; }

            public double shutdown_time { get; set; }

            public double run_average_time { get; set; }

            public double free_average_time { get; set; }

            public double debug_average_time { get; set; }

            public double fault_average_time { get; set; }

            public double shutdown_average_time { get; set; }

            public List<ValueName> MahcineStatusTime { get; set; } = new List<ValueName>();
        }

        internal class ValueName
        {
            public double value { get; set; }

            public string name { get; set; }
        }
    }
}
