﻿using Siger.ApiDashboard.Tasks.Model;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Dapper;
using Siger.Middlelayer.Dapper.Utilities.Slice;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Share.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Tasks.Reports
{
    internal class CustomizationReport : ReporBase
    {
        /// <summary>
        /// FJW 客制化报表
        /// </summary>
        public CustomizationReport()
        {
            var fileName = Path.Combine(RootDir, "MonthReport.html");
            if (!File.Exists(fileName))
                throw new Exception("templates file not found.");

            OriginalContent = FileHelper.ReadFile(fileName);
            if (string.IsNullOrWhiteSpace(OriginalContent))
                throw new Exception("read template file failed.");
        }

        public override ConvertPdfResult GeneratePdf(siger_project_monthreport_config config, string dataStr)
        {
            ReplaceHtml(config, dataStr);
            return ConvertHelper.ConvertToPdf(OriginalContent, config.send_type);
        }

        protected override void ReplaceHtml(siger_project_monthreport_config config, string dataStr)
        {
            OriginalContent = OriginalContent.Replace("{dataArray}", dataStr);
        }
    }
}
