﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Common;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.KpiRespository.Entities;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.KpiRespository.Request;
using Siger.Middlelayer.KpiRespository.Respose;
using Siger.Middlelayer.Share.ModuleEnum;

namespace Siger.ApiKPI.Controllers
{
    public class ActionResultController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerKpiTasklist _kpiTasklist;
        private readonly ISigerKpiActionResult _kpiActionResult ;
        private readonly ISigerKpiAuthority _kpiAuthority;
        private readonly ISigerKpiPushMessage _sigerKpiPushMessage;
        private readonly ISigerProjectSectionRepository _sigerProjectSection;

        public ActionResultController(IUnitOfWork unitOfWork, ISigerKpiTasklist kpiTasklist, ISigerKpiActionResult kpiActionResult,ISigerKpiAuthority kpiAuthority , ISigerKpiPushMessage kpiPushMessage, ISigerProjectSectionRepository sigerProjectSection)
        {
            _unitOfWork = unitOfWork;
            _kpiTasklist = kpiTasklist;
            _kpiActionResult = kpiActionResult;
            _kpiAuthority = kpiAuthority;
            _sigerKpiPushMessage = kpiPushMessage;
            _sigerProjectSection = sigerProjectSection;
        }
        /// <summary>
        /// 处理行动
        /// </summary>
        /// <param name="result"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Add([FromBody]RequestActionResult result)
        {
            var taskObj = _kpiTasklist.Get(result.TaskId);
            if (taskObj==null)
                throw new BadRequestException(CommonEnum.RecordNotFound);

            var permission = _kpiAuthority.VerifyPermission(UserId, taskObj.Section);
            if (!permission)
                throw new BadRequestException(CommonEnum.NoDepartPermission);

            if (result.Fxied == 1)
            {
                taskObj.Result = KpiTaskResult.Normal;
                taskObj.Excption = KpiExecption.Complated;
                _kpiTasklist.Update(taskObj);
            }
            var msgObj = _sigerKpiPushMessage.Get(f => f.ProjectId == ProjectId && f.TaskId == taskObj.id && f.SectionId==taskObj.Section && f.ItemId == taskObj.ItemId);
            if (msgObj != null)
            {
                msgObj.LevelType = KpiPushSettingType.Done;
                msgObj.Push = 0;
                msgObj.LastUpdate = DateTime.Now;
                _sigerKpiPushMessage.Update(msgObj);
            }
            _kpiActionResult.Insert(new SigerProjectKpiActionResult
            {
                TaskId = result.TaskId,
                projectId = ProjectId,
                Operater = result.Operater,
                Solution = result.Solution,
                status = (int)RowState.Valid,
                Result = result.Fxied,
                Creater = UserId,
                Time = DateTime.Now
            });
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                return new ObjectResult(CommonEnum.Fail);
        }
    }
}
