﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.Repository;

namespace Siger.ApiQMS.Controllers
{
    public class CheckSnListController : BaseController
    {
        public IUnitOfWork UnitOfWork { get; }
        public ICheckSnListRepository _CheckSnList { get; }

        public CheckSnListController(IUnitOfWork unitOfWork, ICheckSnListRepository checkSnList)
        {
            UnitOfWork = unitOfWork;
            _CheckSnList = checkSnList;
        }

        [HttpGet]
        public IActionResult GetProductBySn(string sn)
        {

            var obj = _CheckSnList.GetProductBySn(sn, ProjectId);
            if (obj==null)
                throw new BadRequestException(CommonEnum.RecordNotFound);
            return new ObjectResult(obj);
        }

    }
}
