﻿using System;
using System.Collections.Generic;
using System.IO;
using Newtonsoft.Json;
using Siger.ApiCommon.Utilities;
using Siger.ApiQMS.Result;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Log;

namespace Siger.ApiQMS.Utility
{
    public class SpcAnalysisUtility :IDisposable
    {
        public ResponseQMSDynamicDiag CheckDataRule(int itemID, double UCL, double LCL, string traceID, List<double> valueList,
            List<int> rules)
        {
            var request = new RequestQMSDynamicDiag
            {
                itemID = itemID,
                UCL = UCL,
                LCL = LCL,
                traceID = traceID,
                value = $"{string.Join(',', valueList)}",
                rule1 = rules[0],
                rule2 = rules[1],
                rule3 = rules[2],
                rule4 = rules[3],
                rule5 = rules[4],
                rule6 = rules[5],
                rule7 = rules[6],
                rule8 = rules[7],
            };

            try
            {
                var fileSetting = Config<FileSettings>.Get();
                var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, "PythonQMSBI");
                
                var pythonPath = ConfigManager.GetValue("PythonPathSetting", "PyPath", string.Empty);
                if (string.IsNullOrEmpty(pythonPath))
                {
                    throw new Exception("DbSetting about [PythonPathSetting] not found.");
                }
                var pythonScriptPath = $"{rootDir}/QmsBI.py";
                var BIHelper = new PythonBIAbnormalHelper();
                var res = BIHelper.GetAbnormlRuleCheck(pythonPath, pythonScriptPath, "DynamicDiag", request);
                var result = JsonConvert.DeserializeObject<ResponseQMSDynamicDiag>(res);
                return result;
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.ToString());
                return null;                
            }
        }

        public ReponseQmsDynamicHistParams CpkHist(int itemID, double UCL, double LCL, List<double> valueList)
        {
            var request = new RequestQmsDynamicHistParams
            {
                itemID = itemID,
                UCL = UCL,
                LCL = LCL,
                value = $"{string.Join(',', valueList)}",
            };

            try
            {
                var fileSetting = Config<FileSettings>.Get();
                var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, "PythonQMSBI");
                
                var pythonPath = ConfigManager.GetValue("PythonPathSetting", "PyPath", string.Empty);
                if (string.IsNullOrEmpty(pythonPath))
                {
                    throw new Exception("DbSetting about [PythonPathSetting] not found.");
                }
                var pythonScriptPath = $"{rootDir}/QmsBI.py";
                var BIHelper = new PythonBIAbnormalHelper();
                var res = BIHelper.GetCpkHist(pythonPath, pythonScriptPath, "DynamicHistParams", request);
                var result = JsonConvert.DeserializeObject<ReponseQmsDynamicHistParams>(res);
                return result;
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.ToString());
                return null;
            }
        }

        public void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
