﻿using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.Repository.Response;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiTPM.Result
{
    public class AppRepairResult : TpmResultBase
    {
        public int ret { get; set; } = 1;

        public string msg { get; set; } = string.Empty;

        public List<RepairModel> data { get; set; }

        public AppRepairResult()
        {
            data = new List<RepairModel>();
        }

        public int isbindmachine { get; set; }
    }

    public class RepairModel
    {
        public int repairid { get; set; }

        public string createtime { get; set; }

        public int taketime { get; set; }

        public int signtime { get; set; }

        public int checktime { get; set; }

        public int repairtime { get; set; }

        public string repairremark { get; set; }

        public string remark { get; set; }

        public int status { get; set; }

        public int faultid { get; set; }

        public int real_faultid { get; set; }

        public int machineid { get; set; }

        public int completetime { get; set; }

        public int offlinestatus { get; set; }

        public int mid { get; set; }

        public int takemid { get; set; }

        public int signmid { get; set; }

        public int checkmid { get; set; }

        public int repairmid { get; set; }

        public int completemid { get; set; }

        public int report_level { get; set; }

        public string add_repairmid { get; set; }

        public string fault_description { get; set; }

        public string images { get; set; }

        public string username { get; set; }

        public string work_code { get; set; }


        /// <summary>
        /// 是否免打扰
        /// </summary>
        public int mutestatus { get; set; }

        public string answer { get; set; }

        /// <summary>
        /// 序列号
        /// </summary>
        public string serial_number { get; set; }

        public string faultlist { get; set; }

        public int markself { get; set; }

        public List<string> location = new List<string>();

        public int offlinetime { get; set; }

        public string faultcontent { get; set; }

        public List<sparepartidcount> sparepartoutarr { get; set; } = new List<sparepartidcount>();
    }

    public class ResponseGetRepairDetail : RepairModel
    {
        public string fault_desc_img { get; set; }

        public string repair_process { get; set; }

        public string sparepartids { get; set; }

        public string sparepartout { get; set; }

        public string addrepairuser { get; set; }

        public List<MessageModel> message { get; set; } = new List<MessageModel>();

        public int cost { get; set; }
        public string work_order { get; set; }

        public List<ResponseIdName> machineids { get; set; } = new List<ResponseIdName>();
    }
    public class MessageModel
    {
        public int id { get; set; }

        public string title { get; set; }

        public string content { get; set; }

        public string ctime { get; set; }

        /// <summary>
        /// 是否带病复线 0否 1是
        /// </summary>
        public int isrelate { get; set; }

        /// <summary>
        /// 带病复线新增的工单ID
        /// </summary>
        public int relaterepairid { get; set; }
    }

    public class ResponseGetRepairHistory
    {
        public int repairid { get; set; }

        public string workcode { get; set; }

        public int status { get; set; }
    }
}
